/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import io.airlift.discovery.client.DiscoveryException;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.units.Duration;
import java.util.List;

public class ServiceDescriptors {
    private final String type;
    private final String pool;
    private final String eTag;
    private final Duration maxAge;
    private final List<ServiceDescriptor> serviceDescriptors;

    public ServiceDescriptors(ServiceDescriptors serviceDescriptors, Duration maxAge, String eTag) {
        Preconditions.checkNotNull((Object)serviceDescriptors, (Object)"serviceDescriptors is null");
        this.type = serviceDescriptors.type;
        this.pool = serviceDescriptors.pool;
        this.maxAge = maxAge;
        this.eTag = eTag;
        this.serviceDescriptors = serviceDescriptors.serviceDescriptors;
    }

    public ServiceDescriptors(String type, String pool, List<ServiceDescriptor> serviceDescriptors, Duration maxAge, String eTag) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(serviceDescriptors, (Object)"serviceDescriptors is null");
        Preconditions.checkNotNull((Object)maxAge, (Object)"maxAge is null");
        this.type = type;
        this.pool = pool;
        this.serviceDescriptors = serviceDescriptors;
        this.maxAge = maxAge;
        this.eTag = eTag;
        for (ServiceDescriptor serviceDescriptor : this.serviceDescriptors) {
            if (type.equals(serviceDescriptor.getType()) && (pool == null || pool.equals(serviceDescriptor.getPool()))) continue;
            throw new DiscoveryException(String.format("Expected %s service descriptor from pool %s, but was %s service descriptor from pool %s", type, pool, serviceDescriptor.getType(), serviceDescriptor.getPool()));
        }
    }

    public String getType() {
        return this.type;
    }

    public String getPool() {
        return this.pool;
    }

    public String getETag() {
        return this.eTag;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public List<ServiceDescriptor> getServiceDescriptors() {
        return this.serviceDescriptors;
    }
}

