/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import io.airlift.discovery.client.Announcement;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryException;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.JsonBodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.ws.rs.core.CacheControl;

public class HttpDiscoveryAnnouncementClient
implements DiscoveryAnnouncementClient {
    private final Provider<URI> discoveryServiceURI;
    private final NodeInfo nodeInfo;
    private final JsonCodec<Announcement> announcementCodec;
    private final AsyncHttpClient httpClient;

    @Inject
    public HttpDiscoveryAnnouncementClient(@ForDiscoveryClient Provider<URI> discoveryServiceURI, NodeInfo nodeInfo, JsonCodec<Announcement> announcementCodec, @ForDiscoveryClient AsyncHttpClient httpClient) {
        Preconditions.checkNotNull(discoveryServiceURI, (Object)"discoveryServiceURI is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull(announcementCodec, (Object)"announcementCodec is null");
        Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.nodeInfo = nodeInfo;
        this.discoveryServiceURI = discoveryServiceURI;
        this.announcementCodec = announcementCodec;
        this.httpClient = httpClient;
    }

    @Override
    public CheckedFuture<Duration, DiscoveryException> announce(Set<ServiceAnnouncement> services) {
        Preconditions.checkNotNull(services, (Object)"services is null");
        URI uri = (URI)this.discoveryServiceURI.get();
        if (uri == null) {
            return Futures.immediateFailedCheckedFuture((Exception)new DiscoveryException("No discovery servers are available"));
        }
        Announcement announcement = new Announcement(this.nodeInfo.getEnvironment(), this.nodeInfo.getNodeId(), this.nodeInfo.getPool(), this.nodeInfo.getLocation(), services);
        Request request = Request.Builder.preparePut().setUri(URI.create(uri + "/v1/announcement/" + this.nodeInfo.getNodeId())).setHeader("User-Agent", this.nodeInfo.getNodeId()).setHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)JsonBodyGenerator.jsonBodyGenerator(this.announcementCodec, (Object)announcement)).build();
        return this.httpClient.execute(request, (ResponseHandler)new DiscoveryResponseHandler<Duration>("Announcement"){

            @Override
            public Duration handle(Request request, Response response) throws DiscoveryException {
                int statusCode = response.getStatusCode();
                if (!HttpDiscoveryAnnouncementClient.this.isSuccess(statusCode)) {
                    throw new DiscoveryException(String.format("Announcement failed with status code %s: %s", statusCode, HttpDiscoveryAnnouncementClient.getBodyForError(response)));
                }
                Duration maxAge = HttpDiscoveryAnnouncementClient.this.extractMaxAge(response);
                return maxAge;
            }
        });
    }

    private boolean isSuccess(int statusCode) {
        return statusCode / 100 == 2;
    }

    private static String getBodyForError(Response response) {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(response.getInputStream(), Charsets.UTF_8));
        }
        catch (IOException e) {
            return "(error getting body)";
        }
    }

    @Override
    public CheckedFuture<Void, DiscoveryException> unannounce() {
        URI uri = (URI)this.discoveryServiceURI.get();
        if (uri == null) {
            return Futures.immediateFailedCheckedFuture((Exception)new DiscoveryException("No discovery servers are available"));
        }
        Request request = Request.Builder.prepareDelete().setUri(URI.create(uri + "/v1/announcement/" + this.nodeInfo.getNodeId())).setHeader("User-Agent", this.nodeInfo.getNodeId()).build();
        return this.httpClient.execute(request, new DiscoveryResponseHandler("Unannouncement"));
    }

    private Duration extractMaxAge(Response response) {
        CacheControl cacheControl;
        String header = response.getHeader("Cache-Control");
        if (header != null && (cacheControl = CacheControl.valueOf((String)header)).getMaxAge() > 0) {
            return new Duration((double)cacheControl.getMaxAge(), TimeUnit.SECONDS);
        }
        return DEFAULT_DELAY;
    }

    private class DiscoveryResponseHandler<T>
    implements ResponseHandler<T, DiscoveryException> {
        private final String name;

        protected DiscoveryResponseHandler(String name) {
            this.name = name;
        }

        public T handle(Request request, Response response) {
            return null;
        }

        public final DiscoveryException handleException(Request request, Exception exception) {
            if (exception instanceof InterruptedException) {
                return new DiscoveryException(this.name + " was interrupted");
            }
            if (exception instanceof CancellationException) {
                return new DiscoveryException(this.name + " was canceled");
            }
            if (exception instanceof DiscoveryException) {
                throw (DiscoveryException)exception;
            }
            return new DiscoveryException(this.name + " failed", exception);
        }
    }
}

