/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.Announcement;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.CachingServiceSelectorFactory;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryClientConfig;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.discovery.client.HttpDiscoveryAnnouncementClient;
import io.airlift.discovery.client.HttpDiscoveryLookupClient;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceDescriptorsRepresentation;
import io.airlift.discovery.client.ServiceInventory;
import io.airlift.discovery.client.ServiceInventoryConfig;
import io.airlift.discovery.client.ServiceSelectorFactory;
import io.airlift.discovery.client.ServiceState;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.json.JsonCodecBinder;
import java.net.URI;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.weakref.jmx.guice.MBeanModule;

public class DiscoveryModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ServiceInventory.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(ServiceInventoryConfig.class);
        ConfigurationModule.bindConfig((Binder)binder).to(DiscoveryClientConfig.class);
        binder.bind(DiscoveryLookupClient.class).to(HttpDiscoveryLookupClient.class).in(Scopes.SINGLETON);
        binder.bind(DiscoveryAnnouncementClient.class).to(HttpDiscoveryAnnouncementClient.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ServiceDescriptorsRepresentation.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Announcement.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindAsyncHttpClient("discovery", ForDiscoveryClient.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("discovery", ForDiscoveryClient.class);
        binder.bind(Announcer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
        binder.bind(ServiceSelectorFactory.class).to(CachingServiceSelectorFactory.class).in(Scopes.SINGLETON);
        MBeanModule.newExporter((Binder)binder).export(ServiceInventory.class).withGeneratedName();
    }

    @Provides
    @ForDiscoveryClient
    public ScheduledExecutorService createDiscoveryExecutor() {
        return new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Discovery-%s").setDaemon(true).build());
    }

    @Provides
    @ForDiscoveryClient
    public URI getDiscoveryUri(ServiceInventory serviceInventory, DiscoveryClientConfig config) {
        Iterable<ServiceDescriptor> discovery = serviceInventory.getServiceDescriptors("discovery");
        for (ServiceDescriptor descriptor : discovery) {
            if (descriptor.getState() != ServiceState.RUNNING) continue;
            try {
                return new URI(descriptor.getProperties().get("https"));
            }
            catch (Exception e) {
                try {
                    return new URI(descriptor.getProperties().get("http"));
                }
                catch (Exception e2) {
                }
            }
        }
        if (config != null) {
            return config.getDiscoveryServiceURI();
        }
        return null;
    }
}

