/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.CheckedFuture;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryException;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceDescriptors;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;

public class CachingServiceSelector
implements ServiceSelector {
    private static final Logger log = Logger.get(CachingServiceSelector.class);
    private final String type;
    private final String pool;
    private final DiscoveryLookupClient lookupClient;
    private final AtomicReference<ServiceDescriptors> serviceDescriptors = new AtomicReference();
    private final ScheduledExecutorService executor;
    private final AtomicBoolean serverUp = new AtomicBoolean(true);
    private final AtomicBoolean started = new AtomicBoolean(false);

    public CachingServiceSelector(String type, ServiceSelectorConfig selectorConfig, DiscoveryLookupClient lookupClient, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)selectorConfig, (Object)"selectorConfig is null");
        Preconditions.checkNotNull((Object)lookupClient, (Object)"client is null");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.type = type;
        this.pool = selectorConfig.getPool();
        this.lookupClient = lookupClient;
        this.executor = executor;
    }

    @PostConstruct
    public void start() throws TimeoutException {
        if (this.started.compareAndSet(false, true)) {
            Preconditions.checkState((!this.executor.isShutdown() ? 1 : 0) != 0, (Object)"CachingServiceSelector has been destroyed");
            try {
                this.refresh().checkedGet(30L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        ServiceDescriptors serviceDescriptors = this.serviceDescriptors.get();
        if (serviceDescriptors == null) {
            return ImmutableList.of();
        }
        return serviceDescriptors.getServiceDescriptors();
    }

    private CheckedFuture<ServiceDescriptors, DiscoveryException> refresh() {
        ServiceDescriptors oldDescriptors = this.serviceDescriptors.get();
        final CheckedFuture<ServiceDescriptors, DiscoveryException> future = oldDescriptors == null ? this.lookupClient.getServices(this.type, this.pool) : this.lookupClient.refreshServices(oldDescriptors);
        future.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Duration delay = DiscoveryAnnouncementClient.DEFAULT_DELAY;
                try {
                    ServiceDescriptors newDescriptors = (ServiceDescriptors)future.checkedGet();
                    delay = newDescriptors.getMaxAge();
                    CachingServiceSelector.this.serviceDescriptors.set(newDescriptors);
                    if (CachingServiceSelector.this.serverUp.compareAndSet(false, true)) {
                        log.info("Discovery server connect succeeded for refresh (%s/%s)", new Object[]{CachingServiceSelector.this.type, CachingServiceSelector.this.pool});
                    }
                }
                catch (DiscoveryException e) {
                    if (CachingServiceSelector.this.serverUp.compareAndSet(true, false)) {
                        log.error("Cannot connect to discovery server for refresh (%s/%s): %s", new Object[]{CachingServiceSelector.this.type, CachingServiceSelector.this.pool, e.getMessage()});
                    }
                    log.debug((Throwable)e, "Cannot connect to discovery server for refresh (%s/%s)", new Object[]{CachingServiceSelector.this.type, CachingServiceSelector.this.pool});
                }
                finally {
                    CachingServiceSelector.this.scheduleRefresh(delay);
                }
            }
        }, (Executor)this.executor);
        return future;
    }

    private void scheduleRefresh(Duration delay) {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                CachingServiceSelector.this.refresh();
            }
        }, (long)delay.toMillis(), TimeUnit.MILLISECONDS);
    }
}

