/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryException;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.ConnectException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;

public class Announcer {
    private static final Logger log = Logger.get(Announcer.class);
    private final ConcurrentMap<UUID, ServiceAnnouncement> announcements = new MapMaker().makeMap();
    private final DiscoveryAnnouncementClient announcementClient;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean serverUp = new AtomicBoolean(true);
    private final AtomicBoolean started = new AtomicBoolean(false);

    @Inject
    public Announcer(DiscoveryAnnouncementClient announcementClient, Set<ServiceAnnouncement> serviceAnnouncements) {
        Preconditions.checkNotNull((Object)announcementClient, (Object)"client is null");
        Preconditions.checkNotNull(serviceAnnouncements, (Object)"serviceAnnouncements is null");
        this.announcementClient = announcementClient;
        for (ServiceAnnouncement serviceAnnouncement : serviceAnnouncements) {
            this.announcements.put(serviceAnnouncement.getId(), serviceAnnouncement);
        }
        this.executor = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Announcer-%s").setDaemon(true).build());
    }

    public void start() throws TimeoutException {
        Preconditions.checkState((!this.executor.isShutdown() ? 1 : 0) != 0, (Object)"Announcer has been destroyed");
        if (this.started.compareAndSet(false, true)) {
            try {
                this.announce().checkedGet(30L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.announcementClient.unannounce().checkedGet();
        }
        catch (DiscoveryException e) {
            if (e.getCause() instanceof ConnectException) {
                log.error("Cannot connect to discovery server for unannounce: %s", new Object[]{e.getCause().getMessage()});
            }
            log.error((Throwable)e);
        }
    }

    public void addServiceAnnouncement(ServiceAnnouncement serviceAnnouncement) {
        Preconditions.checkNotNull((Object)serviceAnnouncement, (Object)"serviceAnnouncement is null");
        this.announcements.put(serviceAnnouncement.getId(), serviceAnnouncement);
    }

    public void removeServiceAnnouncement(UUID serviceId) {
        this.announcements.remove(serviceId);
    }

    private CheckedFuture<Duration, DiscoveryException> announce() {
        final CheckedFuture<Duration, DiscoveryException> future = this.announcementClient.announce((Set<ServiceAnnouncement>)ImmutableSet.copyOf(this.announcements.values()));
        future.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Duration duration = DiscoveryAnnouncementClient.DEFAULT_DELAY;
                try {
                    duration = (Duration)future.checkedGet();
                    if (Announcer.this.serverUp.compareAndSet(false, true)) {
                        log.info("Discovery server connect succeeded for announce", new Object[0]);
                    }
                }
                catch (DiscoveryException e) {
                    if (Announcer.this.serverUp.compareAndSet(true, false)) {
                        log.error("Cannot connect to discovery server for announce: %s", new Object[]{e.getMessage()});
                    }
                    log.debug((Throwable)e, "Cannot connect to discovery server for announce", new Object[0]);
                }
                finally {
                    Announcer.this.scheduleNextAnnouncement(duration);
                }
            }
        }, (Executor)this.executor);
        return future;
    }

    private void scheduleNextAnnouncement(Duration delay) {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                Announcer.this.announce();
            }
        }, (long)(delay.toMillis() * 0.8), TimeUnit.MILLISECONDS);
    }
}

