/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import io.airlift.discovery.client.ServiceAnnouncement;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;

public class Announcement {
    private final String environment;
    private final String nodeId;
    private final String location;
    private final String pool;
    private final Set<ServiceAnnouncement> services;

    public Announcement(String environment, String nodeId, String pool, String location, Set<ServiceAnnouncement> services) {
        Preconditions.checkNotNull((Object)environment, (Object)"environment is null");
        Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId is null");
        Preconditions.checkNotNull(services, (Object)"services is null");
        Preconditions.checkNotNull((Object)pool, (Object)"pool is null");
        Preconditions.checkArgument((!services.isEmpty() ? 1 : 0) != 0, (Object)"services is empty");
        this.environment = environment;
        this.nodeId = nodeId;
        this.location = location;
        this.pool = pool;
        this.services = services;
    }

    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty
    public String getNodeId() {
        return this.nodeId;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public String getPool() {
        return this.pool;
    }

    @JsonProperty
    public Set<ServiceAnnouncement> getServices() {
        return this.services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Announcement that = (Announcement)o;
        return this.nodeId.equals(that.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        return "Announcement{environment='" + this.environment + '\'' + ", nodeId='" + this.nodeId + '\'' + ", location='" + this.location + '\'' + ", pool='" + this.pool + '\'' + ", services=" + this.services + '}';
    }
}

