/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.cassandra.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import io.airlift.cassandra.CassandraServerConfig;
import io.airlift.cassandra.CassandraServerInfo;
import io.airlift.cassandra.EmbeddedCassandraServer;
import io.airlift.node.NodeInfo;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.thrift.transport.TTransportException;

public class CassandraServerSetup {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static final AtomicBoolean shutdown = new AtomicBoolean();
    private static File tempDir;
    private static EmbeddedCassandraServer server;
    private static int rpcPort;
    private static NodeInfo nodeInfo;

    public static void tryInitialize() throws IOException, TTransportException, ConfigurationException, InterruptedException {
        Preconditions.checkState((!shutdown.get() ? 1 : 0) != 0, (Object)"Cassandra has already been shut down");
        if (initialized.compareAndSet(false, true)) {
            rpcPort = CassandraServerSetup.findUnusedPort();
            tempDir = Files.createTempDir();
            CassandraServerConfig config = new CassandraServerConfig().setPartitioner(CassandraServerConfig.Partitioner.BYTE_ORDERED).setSeeds("localhost").setStoragePort(CassandraServerSetup.findUnusedPort()).setRpcPort(rpcPort).setClusterName("megacluster").setDirectory(tempDir);
            nodeInfo = new NodeInfo("testing");
            server = new EmbeddedCassandraServer(config, nodeInfo);
            server.start();
        }
    }

    public static void tryShutdown() throws IOException {
        if (shutdown.compareAndSet(false, true)) {
            server.stop();
            CassandraServerSetup.deleteRecursively(tempDir);
        }
    }

    public static CassandraServerInfo getServerInfo() {
        Preconditions.checkState((boolean)initialized.get(), (Object)"Embedded Cassandra instance not yet initialized. Make sure to call tryInitialize() before calling this method.");
        return new CassandraServerInfo(nodeInfo.getBindIp(), rpcPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findUnusedPort() throws IOException {
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(0));
            int n = socket.getLocalPort();
            return n;
        }
    }

    private static boolean deleteDirectoryContents(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"Not a directory: %s", (Object[])new Object[]{directory});
        if (CassandraServerSetup.isSymbolicLink(directory)) {
            return false;
        }
        boolean success = true;
        for (File file : CassandraServerSetup.listFiles(directory)) {
            success = CassandraServerSetup.deleteRecursively(file) && success;
        }
        return success;
    }

    private static boolean deleteRecursively(File file) {
        boolean success = true;
        if (file.isDirectory()) {
            success = CassandraServerSetup.deleteDirectoryContents(file);
        }
        return file.delete() && success;
    }

    private static boolean isSymbolicLink(File file) {
        try {
            File canonicalFile = file.getCanonicalFile();
            File absoluteFile = file.getAbsoluteFile();
            return !canonicalFile.getName().equals(absoluteFile.getName()) || !canonicalFile.getParent().equals(absoluteFile.getParentFile().getCanonicalPath());
        }
        catch (IOException e) {
            return true;
        }
    }

    private static ImmutableList<File> listFiles(File dir) {
        Object[] files = dir.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])files);
    }
}

