/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.cassandra;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.net.InetAddresses;
import io.airlift.cassandra.CassandraServerConfig;
import io.airlift.cassandra.EmbeddedCassandraDaemon;
import io.airlift.node.NodeInfo;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.thrift.transport.TTransportException;
import org.yaml.snakeyaml.Yaml;

public class EmbeddedCassandraServer {
    private final CassandraDaemon cassandra;
    private final InetAddress rpcAddress;
    private final int rpcPort;

    @Inject
    public EmbeddedCassandraServer(CassandraServerConfig config, NodeInfo nodeInfo) throws TTransportException, IOException, InterruptedException, ConfigurationException {
        File directory = config.getDirectory();
        if (!directory.mkdirs() && !directory.exists()) {
            throw new IllegalStateException(String.format("Directory %s does not exist and cannot be created", directory));
        }
        this.rpcAddress = nodeInfo.getBindIp();
        this.rpcPort = config.getRpcPort();
        ImmutableList seedProvider = ImmutableList.of((Object)ImmutableMap.of((Object)"class_name", (Object)"org.apache.cassandra.locator.SimpleSeedProvider", (Object)"parameters", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"seeds", (Object)config.getSeeds()))));
        ImmutableMap map = ImmutableMap.builder().put((Object)"cluster_name", (Object)config.getClusterName()).put((Object)"auto_bootstrap", (Object)"false").put((Object)"hinted_handoff_enabled", (Object)"true").put((Object)"partitioner", (Object)config.getPartitioner().getClazz().getName()).put((Object)"data_file_directories", Arrays.asList(new File(directory, "data").getAbsolutePath())).put((Object)"commitlog_directory", (Object)new File(directory, "commitlog").getAbsolutePath()).put((Object)"saved_caches_directory", (Object)new File(directory, "saved_caches").getAbsolutePath()).put((Object)"commitlog_sync", (Object)"periodic").put((Object)"commitlog_sync_period_in_ms", (Object)"10000").put((Object)"disk_access_mode", (Object)"auto").put((Object)"storage_port", (Object)config.getStoragePort()).put((Object)"listen_address", (Object)InetAddresses.toUriString((InetAddress)nodeInfo.getInternalIp())).put((Object)"rpc_address", (Object)InetAddresses.toUriString((InetAddress)this.rpcAddress)).put((Object)"rpc_port", (Object)this.rpcPort).put((Object)"endpoint_snitch", (Object)"org.apache.cassandra.locator.SimpleSnitch").put((Object)"request_scheduler", (Object)"org.apache.cassandra.scheduler.NoScheduler").put((Object)"in_memory_compaction_limit_in_mb", (Object)((int)config.getInMemoryCompactionLimit().getValue(DataSize.Unit.MEGABYTE))).put((Object)"sliced_buffer_size_in_kb", (Object)64).put((Object)"thrift_framed_transport_size_in_mb", (Object)3).put((Object)"thrift_max_message_length_in_mb", (Object)4).put((Object)"column_index_size_in_kb", (Object)((int)config.getColumnIndexSize().getValue(DataSize.Unit.KILOBYTE))).put((Object)"seed_provider", (Object)seedProvider).put((Object)"encryption_options", (Object)ImmutableMap.of((Object)"internode_encryption", (Object)"none")).put((Object)"rpc_timeout_in_ms", (Object)((int)config.getRpcTimeout().toMillis())).put((Object)"memtable_total_space_in_mb", (Object)((int)config.getMemtableTotalSpace().getValue(DataSize.Unit.MEGABYTE))).build();
        File configFile = new File(directory, "config.yaml");
        Files.write((CharSequence)new Yaml().dump((Object)map), (File)configFile, (Charset)Charsets.UTF_8);
        System.setProperty("cassandra.config", configFile.toURI().toString());
        this.cassandra = new EmbeddedCassandraDaemon();
        this.cassandra.init(null);
    }

    @PostConstruct
    public void start() {
        try {
            this.cassandra.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.waitForListener();
    }

    void waitForListener() {
        InetSocketAddress testAddress = new InetSocketAddress(this.rpcAddress, this.rpcPort);
        long start = System.nanoTime();
        while (Duration.nanosSince((long)start).toMillis() < (double)TimeUnit.MINUTES.toMillis(1L)) {
            try {
                Socket testSocket = new Socket();
                testSocket.connect(testAddress, (int)TimeUnit.SECONDS.toMillis(1L));
                testSocket.close();
                return;
            }
            catch (IOException e) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(interrupted);
                }
            }
        }
    }

    @PreDestroy
    public void stop() {
        this.cassandra.stop();
    }

    public InetAddress getRpcAddress() {
        return this.rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }
}

