/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.cassandra;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.service.AbstractCassandraDaemon;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CassandraServer;
import org.apache.cassandra.thrift.CustomTThreadPoolServer;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.thrift.TCustomServerSocket;
import org.apache.cassandra.utils.CLibrary;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class EmbeddedCassandraDaemon
implements CassandraDaemon {
    private static final Logger log = Logger.get(EmbeddedCassandraDaemon.class);
    private int listenPort;
    private InetAddress listenAddr;
    private ThriftServer server;
    private boolean isRunning;

    public void init(String[] arguments) throws IOException {
        try {
            this.setup();
        }
        catch (ConfigurationException e) {
            throw new IOException("Fatal exception during initialization", e);
        }
    }

    public void start() throws IOException {
        this.startRPCServer();
    }

    public void stop() {
        this.stopRPCServer();
    }

    public void destroy() {
        throw new AssertionError((Object)"destroy method not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRPCServer() {
        EmbeddedCassandraDaemon embeddedCassandraDaemon = this;
        synchronized (embeddedCassandraDaemon) {
            if (!this.isRunning) {
                log.info("Cassandra starting...", new Object[0]);
                this.server = new ThriftServer(this.listenAddr, this.listenPort);
                this.server.start();
                this.isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRPCServer() {
        EmbeddedCassandraDaemon embeddedCassandraDaemon = this;
        synchronized (embeddedCassandraDaemon) {
            if (this.isRunning) {
                log.info("Cassandra shutting down...", new Object[0]);
                this.server.stopServer();
                try {
                    this.server.join();
                }
                catch (InterruptedException e) {
                    log.error((Throwable)e, "Interrupted while waiting for thrift server to stop", new Object[0]);
                    Thread.currentThread().interrupt();
                }
                this.isRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRPCServerRunning() {
        EmbeddedCassandraDaemon embeddedCassandraDaemon = this;
        synchronized (embeddedCassandraDaemon) {
            return this.isRunning;
        }
    }

    public void activate() {
        throw new AssertionError((Object)"activate method not implemented");
    }

    public void deactivate() {
        throw new AssertionError((Object)"deactivate method not implemented");
    }

    private void setup() throws IOException, ConfigurationException {
        log.info("Heap size: %s/%s", new Object[]{Runtime.getRuntime().totalMemory(), Runtime.getRuntime().maxMemory()});
        CLibrary.tryMlockall();
        this.listenPort = DatabaseDescriptor.getRpcPort();
        this.listenAddr = DatabaseDescriptor.getRpcAddress();
        Preconditions.checkNotNull((Object)this.listenPort, (Object)"rpc port is null");
        Preconditions.checkNotNull((Object)this.listenAddr, (Object)"rpc address is null");
        for (CFMetaData cfm : DatabaseDescriptor.getTableMetaData((String)"system").values()) {
            ColumnFamilyStore.scrubDataDirectories((String)"system", (String)cfm.cfName);
        }
        SystemTable.checkHealth();
        DatabaseDescriptor.loadSchemas();
        for (String table : DatabaseDescriptor.getTables()) {
            for (CFMetaData cfm : DatabaseDescriptor.getTableMetaData((String)table).values()) {
                ColumnFamilyStore.scrubDataDirectories((String)table, (String)cfm.cfName);
            }
        }
        for (String table : DatabaseDescriptor.getTables()) {
            log.debug("opening keyspace " + table, new Object[0]);
            Table.open((String)table);
        }
        try {
            GCInspector.instance.start();
        }
        catch (Throwable t) {
            log.warn("Unable to start GCInspector (currently only supported on the Sun JVM)", new Object[0]);
        }
        CommitLog.recover();
        UUID currentMigration = DatabaseDescriptor.getDefsVersion();
        UUID lastMigration = Migration.getLastMigrationId();
        if (lastMigration != null && lastMigration.timestamp() > currentMigration.timestamp()) {
            Gossiper.instance.maybeInitializeLocalState(SystemTable.incrementAndGetGeneration());
            MigrationManager.applyMigrations((UUID)currentMigration, (UUID)lastMigration);
        }
        SystemTable.purgeIncompatibleHints();
        StorageService.instance.registerDaemon((CassandraDaemon)this);
        StorageService.instance.initServer();
    }

    private static class ThriftServer
    extends Thread {
        private final TServer serverEngine;

        public ThriftServer(InetAddress listenAddr, int listenPort) {
            TCustomServerSocket tServerSocket;
            this.setName("ThriftServer");
            CassandraServer cassandraServer = new CassandraServer();
            Cassandra.Processor processor = new Cassandra.Processor((Cassandra.Iface)cassandraServer);
            String socketName = String.format("%s:%s", listenAddr.getHostAddress(), listenPort);
            try {
                log.info("Binding thrift service to " + socketName, new Object[0]);
                tServerSocket = new TCustomServerSocket(new InetSocketAddress(listenAddr, listenPort), DatabaseDescriptor.getRpcKeepAlive(), DatabaseDescriptor.getRpcSendBufferSize(), DatabaseDescriptor.getRpcRecvBufferSize());
            }
            catch (TTransportException e) {
                throw new RuntimeException("Unable to create thrift socket to " + socketName, e);
            }
            TBinaryProtocol.Factory tProtocolFactory = new TBinaryProtocol.Factory(true, true, DatabaseDescriptor.getThriftMaxMessageLength());
            int tFramedTransportSize = DatabaseDescriptor.getThriftFramedTransportSize();
            TFramedTransport.Factory inTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            TFramedTransport.Factory outTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            log.info("Using TFastFramedTransport with a max frame size of %s bytes", new Object[]{tFramedTransportSize});
            TThreadPoolServer.Args args = (TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)tServerSocket).minWorkerThreads(DatabaseDescriptor.getRpcMinThreads().intValue()).maxWorkerThreads(DatabaseDescriptor.getRpcMaxThreads().intValue()).inputTransportFactory((TTransportFactory)inTransportFactory)).outputTransportFactory((TTransportFactory)outTransportFactory)).inputProtocolFactory((TProtocolFactory)tProtocolFactory)).outputProtocolFactory((TProtocolFactory)tProtocolFactory)).processor((TProcessor)processor);
            AbstractCassandraDaemon.CleaningThreadPool executorService = new AbstractCassandraDaemon.CleaningThreadPool(cassandraServer.clientState, args.minWorkerThreads, args.maxWorkerThreads);
            this.serverEngine = new CustomTThreadPoolServer(args, (ExecutorService)executorService);
        }

        @Override
        public void run() {
            log.info("Listening for thrift clients...", new Object[0]);
            this.serverEngine.serve();
        }

        public void stopServer() {
            log.info("Stopping listening for thrift clients", new Object[0]);
            this.serverEngine.stop();
        }
    }
}

