/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.cassandra;

import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.CollatingOrderPreservingPartitioner;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.dht.RandomPartitioner;

public class CassandraServerConfig {
    private String clusterName = "cluster";
    private File directory;
    private int rpcPort = 9160;
    private int storagePort = 7000;
    private Duration rpcTimeout = new Duration(2.0, TimeUnit.SECONDS);
    private String seeds;
    private DataSize inMemoryCompactionLimit = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize columnIndexSize = new DataSize(16.0, DataSize.Unit.KILOBYTE);
    private Partitioner partitioner = Partitioner.RANDOM;
    private DataSize memtableTotalSpace = new DataSize((double)(Runtime.getRuntime().maxMemory() / 0x300000L), DataSize.Unit.MEGABYTE);

    @Config(value="cassandra.cluster-name")
    public CassandraServerConfig setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @NotNull
    public String getClusterName() {
        return this.clusterName;
    }

    @Config(value="cassandra.directory")
    public CassandraServerConfig setDirectory(File directory) {
        this.directory = directory;
        return this;
    }

    @NotNull
    public File getDirectory() {
        return this.directory;
    }

    @Config(value="cassandra.rpc-port")
    public CassandraServerConfig setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
        return this;
    }

    @Min(value=1L)
    @Max(value=65535L)
    public int getRpcPort() {
        return this.rpcPort;
    }

    @Config(value="cassandra.storage-port")
    public CassandraServerConfig setStoragePort(int storagePort) {
        this.storagePort = storagePort;
        return this;
    }

    @Min(value=1L)
    @Max(value=65535L)
    public int getStoragePort() {
        return this.storagePort;
    }

    @Config(value="cassandra.rpc-timeout")
    public CassandraServerConfig setRpcTimeout(Duration rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
        return this;
    }

    @NotNull
    public Duration getRpcTimeout() {
        return this.rpcTimeout;
    }

    @Config(value="cassandra.seeds")
    public CassandraServerConfig setSeeds(String seeds) {
        this.seeds = seeds;
        return this;
    }

    @NotNull
    public String getSeeds() {
        return this.seeds;
    }

    @Config(value="cassandra.in-memory-compaction-limit")
    public CassandraServerConfig setInMemoryCompactionLimit(DataSize inMemoryCompactionLimit) {
        this.inMemoryCompactionLimit = inMemoryCompactionLimit;
        return this;
    }

    @NotNull
    public DataSize getInMemoryCompactionLimit() {
        return this.inMemoryCompactionLimit;
    }

    @Config(value="cassandra.column-index-size")
    public CassandraServerConfig setColumnIndexSize(DataSize columnIndexSize) {
        this.columnIndexSize = columnIndexSize;
        return this;
    }

    @NotNull
    public DataSize getColumnIndexSize() {
        return this.columnIndexSize;
    }

    @Config(value="cassandra.partitioner")
    public CassandraServerConfig setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
        return this;
    }

    @NotNull
    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    @Config(value="cassandra.memtable-total-space")
    public CassandraServerConfig setMemtableTotalSpace(DataSize memtableTotalSpace) {
        this.memtableTotalSpace = memtableTotalSpace;
        return this;
    }

    @NotNull
    public DataSize getMemtableTotalSpace() {
        return this.memtableTotalSpace;
    }

    public static enum Partitioner {
        RANDOM(RandomPartitioner.class),
        ORDER_PRESERVING(OrderPreservingPartitioner.class),
        BYTE_ORDERED(ByteOrderedPartitioner.class),
        COLLATING_ORDER_PRESERVING(CollatingOrderPreservingPartitioner.class);

        private Class clazz;

        private Partitioner(Class clazz) {
            this.clazz = clazz;
        }

        public Class getClazz() {
            return this.clazz;
        }
    }
}

