package ingraph.optimization.transformations.reteoptimization;

import com.google.common.base.Objects;
import ingraph.optimization.patterns.AssociativeOperatorMatch;
import ingraph.optimization.patterns.AssociativeOperatorMatcher;
import ingraph.optimization.patterns.CascadableSelectionMatch;
import ingraph.optimization.patterns.CascadableSelectionMatcher;
import ingraph.optimization.patterns.CommutativeOperatorMatch;
import ingraph.optimization.patterns.CommutativeOperatorMatcher;
import ingraph.optimization.patterns.SwappableSelectionMatch;
import ingraph.optimization.patterns.SwappableSelectionMatcher;
import ingraph.optimization.transformations.AbstractRelalgTransformation;
import ingraph.optimization.transformations.reteoptimization.ReteCostObjective;
import org.eclipse.viatra.dse.api.DesignSpaceExplorer;
import org.eclipse.viatra.dse.api.Objectives;
import org.eclipse.viatra.dse.api.SolutionTrajectory;
import org.eclipse.viatra.dse.api.Strategies;
import org.eclipse.viatra.dse.api.strategy.impl.DepthFirstStrategy;
import org.eclipse.viatra.dse.objectives.impl.DummyHardObjective;
import org.eclipse.viatra.dse.solutionstore.SolutionStore;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformationStatements;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import relalg.CommutativeBinaryOperator;
import relalg.JoinOperator;
import relalg.LogicalExpression;
import relalg.Operator;
import relalg.RelalgContainer;
import relalg.RelalgPackage;
import relalg.SelectionOperator;

@SuppressWarnings("all")
public class ReteOptimization extends AbstractRelalgTransformation {
  public RelalgContainer performSimpleOptimization(final RelalgContainer container) {
    final BatchTransformationStatements statements = this.register(container);
    BatchTransformationRule<CascadableSelectionMatch, CascadableSelectionMatcher> _cascadingSelectionsRule = this.cascadingSelectionsRule();
    statements.<CascadableSelectionMatch>fireAllCurrent(_cascadingSelectionsRule);
    BatchTransformationRule<SwappableSelectionMatch, SwappableSelectionMatcher> _swappableSelectionsRule = this.swappableSelectionsRule();
    statements.<SwappableSelectionMatch>fireAllCurrent(_swappableSelectionsRule);
    BatchTransformationRule<AssociativeOperatorMatch, AssociativeOperatorMatcher> _associativeOperatorRule = this.associativeOperatorRule();
    statements.<AssociativeOperatorMatch>fireAllCurrent(_associativeOperatorRule);
    BatchTransformationRule<CommutativeOperatorMatch, CommutativeOperatorMatcher> _commutativeOperatorRule = this.commutativeOperatorRule();
    statements.<CommutativeOperatorMatch>fireAllCurrent(_commutativeOperatorRule);
    return container;
  }
  
  public RelalgContainer performDseOptimization(final RelalgContainer container) {
    try {
      DesignSpaceExplorer.turnOnLogging(DesignSpaceExplorer.DseLoggingLevel.OFF);
      final DesignSpaceExplorer dse = new DesignSpaceExplorer();
      dse.setInitialModel(container);
      dse.addMetaModelPackage(RelalgPackage.eINSTANCE);
      BatchTransformationRule<CascadableSelectionMatch, CascadableSelectionMatcher> _cascadingSelectionsRule = this.cascadingSelectionsRule();
      dse.addTransformationRule(_cascadingSelectionsRule);
      DepthFirstStrategy _createDfsStrategy = Strategies.createDfsStrategy();
      final DepthFirstStrategy strategy = _createDfsStrategy.continueIfHardObjectivesFulfilled();
      DummyHardObjective _createDummyHardObjective = Objectives.createDummyHardObjective();
      dse.addObjective(_createDummyHardObjective);
      ReteCostObjective _reteCostObjective = new ReteCostObjective();
      dse.addObjective(_reteCostObjective);
      SolutionStore _solutionStore = new SolutionStore(0);
      SolutionStore _storeBestSolutionsOnly = _solutionStore.storeBestSolutionsOnly();
      dse.setSolutionStore(_storeBestSolutionsOnly);
      dse.startExploration(strategy);
      final SolutionTrajectory solution = dse.getArbitrarySolution();
      boolean _notEquals = (!Objects.equal(solution, null));
      if (_notEquals) {
        solution.doTransformation(container);
      } else {
        InputOutput.<String>println("No solution found");
      }
      return container;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected BatchTransformationRule<CascadableSelectionMatch, CascadableSelectionMatcher> cascadingSelectionsRule() {
    try {
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<CascadableSelectionMatch, CascadableSelectionMatcher> _createRule = this.ruleFactory.<CascadableSelectionMatch, CascadableSelectionMatcher>createRule();
      IQuerySpecification<CascadableSelectionMatcher> _querySpecification = CascadableSelectionMatcher.querySpecification();
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<CascadableSelectionMatch, CascadableSelectionMatcher> _precondition = _createRule.precondition(_querySpecification);
      final IMatchProcessor<CascadableSelectionMatch> _function = (CascadableSelectionMatch it) -> {
        System.err.println("cascadeConditionRule fired");
        final SelectionOperator selectionOperator = it.getSelectionOperator();
        final LogicalExpression leftOperand = it.getLeftOperand();
        final LogicalExpression rightOperand = it.getRightOperand();
        SelectionOperator _createSelectionOperator = this.relalgFactory.createSelectionOperator();
        final Procedure1<SelectionOperator> _function_1 = (SelectionOperator it_1) -> {
          it_1.setCondition(leftOperand);
          Operator _input = selectionOperator.getInput();
          it_1.setInput(_input);
        };
        final SelectionOperator selectionOperator1 = ObjectExtensions.<SelectionOperator>operator_doubleArrow(_createSelectionOperator, _function_1);
        SelectionOperator _createSelectionOperator_1 = this.relalgFactory.createSelectionOperator();
        final Procedure1<SelectionOperator> _function_2 = (SelectionOperator it_1) -> {
          it_1.setCondition(rightOperand);
          it_1.setInput(selectionOperator1);
        };
        final SelectionOperator selectionOperator2 = ObjectExtensions.<SelectionOperator>operator_doubleArrow(_createSelectionOperator_1, _function_2);
        Operator _parentOperator = it.getParentOperator();
        this.changeOperator(_parentOperator, selectionOperator, selectionOperator2);
      };
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<CascadableSelectionMatch, CascadableSelectionMatcher> _action = _precondition.action(_function);
      return _action.build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected BatchTransformationRule<SwappableSelectionMatch, SwappableSelectionMatcher> swappableSelectionsRule() {
    try {
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<SwappableSelectionMatch, SwappableSelectionMatcher> _createRule = this.ruleFactory.<SwappableSelectionMatch, SwappableSelectionMatcher>createRule();
      IQuerySpecification<SwappableSelectionMatcher> _querySpecification = SwappableSelectionMatcher.querySpecification();
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<SwappableSelectionMatch, SwappableSelectionMatcher> _precondition = _createRule.precondition(_querySpecification);
      final IMatchProcessor<SwappableSelectionMatch> _function = (SwappableSelectionMatch it) -> {
        System.err.println("swappableSelections fired");
        SelectionOperator _selectionOperator1 = it.getSelectionOperator1();
        SelectionOperator _selectionOperator2 = it.getSelectionOperator2();
        Operator _input = _selectionOperator2.getInput();
        _selectionOperator1.setInput(_input);
        SelectionOperator _selectionOperator2_1 = it.getSelectionOperator2();
        SelectionOperator _selectionOperator1_1 = it.getSelectionOperator1();
        _selectionOperator2_1.setInput(_selectionOperator1_1);
        Operator _parentOperator = it.getParentOperator();
        SelectionOperator _selectionOperator1_2 = it.getSelectionOperator1();
        SelectionOperator _selectionOperator2_2 = it.getSelectionOperator2();
        this.changeOperator(_parentOperator, _selectionOperator1_2, _selectionOperator2_2);
      };
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<SwappableSelectionMatch, SwappableSelectionMatcher> _action = _precondition.action(_function);
      return _action.build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected BatchTransformationRule<CommutativeOperatorMatch, CommutativeOperatorMatcher> commutativeOperatorRule() {
    try {
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<CommutativeOperatorMatch, CommutativeOperatorMatcher> _createRule = this.ruleFactory.<CommutativeOperatorMatch, CommutativeOperatorMatcher>createRule();
      IQuerySpecification<CommutativeOperatorMatcher> _querySpecification = CommutativeOperatorMatcher.querySpecification();
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<CommutativeOperatorMatch, CommutativeOperatorMatcher> _precondition = _createRule.precondition(_querySpecification);
      final IMatchProcessor<CommutativeOperatorMatch> _function = (CommutativeOperatorMatch it) -> {
        System.err.println("commutativeJoin fired");
        CommutativeBinaryOperator _op = it.getOp();
        Operator _leftInput = it.getLeftInput();
        _op.setRightInput(_leftInput);
        CommutativeBinaryOperator _op_1 = it.getOp();
        Operator _rightInput = it.getRightInput();
        _op_1.setLeftInput(_rightInput);
      };
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<CommutativeOperatorMatch, CommutativeOperatorMatcher> _action = _precondition.action(_function);
      return _action.build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected BatchTransformationRule<AssociativeOperatorMatch, AssociativeOperatorMatcher> associativeOperatorRule() {
    try {
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<AssociativeOperatorMatch, AssociativeOperatorMatcher> _createRule = this.ruleFactory.<AssociativeOperatorMatch, AssociativeOperatorMatcher>createRule();
      IQuerySpecification<AssociativeOperatorMatcher> _querySpecification = AssociativeOperatorMatcher.querySpecification();
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<AssociativeOperatorMatch, AssociativeOperatorMatcher> _precondition = _createRule.precondition(_querySpecification);
      final IMatchProcessor<AssociativeOperatorMatch> _function = (AssociativeOperatorMatch it) -> {
        System.err.println("associativeJoin fired");
        JoinOperator _op2 = it.getOp2();
        Operator _a = it.getA();
        _op2.setLeftInput(_a);
        JoinOperator _op2_1 = it.getOp2();
        JoinOperator _op1 = it.getOp1();
        _op2_1.setRightInput(_op1);
        JoinOperator _op1_1 = it.getOp1();
        Operator _b = it.getB();
        _op1_1.setLeftInput(_b);
        JoinOperator _op1_2 = it.getOp1();
        Operator _c = it.getC();
        _op1_2.setRightInput(_c);
      };
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<AssociativeOperatorMatch, AssociativeOperatorMatcher> _action = _precondition.action(_function);
      return _action.build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
