package ingraph.optimization.transformations.reteoptimization;

import ingraph.optimization.transformations.cost.ReteCostFunction;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.impl.BaseObjective;
import relalg.RelalgContainer;

@SuppressWarnings("all")
public class ReteCostObjective extends BaseObjective {
  private final ReteCostFunction reteCostFunction = new ReteCostFunction();
  
  public ReteCostObjective() {
    super("Rete cost objective");
  }
  
  @Override
  public IObjective createNew() {
    return new ReteCostObjective();
  }
  
  @Override
  public Double getFitness(final ThreadContext context) {
    Double _xblockexpression = null;
    {
      Notifier _model = context.getModel();
      final RelalgContainer container = ((RelalgContainer) _model);
      _xblockexpression = this.reteCostFunction.getEstimation(container);
    }
    return _xblockexpression;
  }
}
