package ingraph.optimization.transformations.relalg2rete;

import ingraph.optimization.patterns.ExpandOperatorMatch;
import ingraph.optimization.patterns.ExpandOperatorMatcher;
import ingraph.optimization.patterns.ExpandVertexMatch;
import ingraph.optimization.patterns.ExpandVertexMatcher;
import ingraph.optimization.transformations.AbstractRelalgTransformation;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformationStatements;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import relalg.EdgeVariable;
import relalg.ExpandOperator;
import relalg.GetEdgesOperator;
import relalg.JoinOperator;
import relalg.Operator;
import relalg.RelalgContainer;
import relalg.VertexVariable;

@SuppressWarnings("all")
public class Relalg2ReteTransformation extends AbstractRelalgTransformation {
  public Relalg2ReteTransformation() {
    final Logger logger = Logger.getRootLogger();
    logger.setLevel(Level.ERROR);
    ViatraQueryLoggingUtil.setExternalLogger(logger);
  }
  
  public Object log(final String log) {
    return null;
  }
  
  public RelalgContainer transformToRete(final RelalgContainer container) {
    final BatchTransformationStatements statements = this.register(container);
    BatchTransformationRule<ExpandVertexMatch, ExpandVertexMatcher> _expandVertexRule = this.expandVertexRule();
    statements.<ExpandVertexMatch>fireWhilePossible(_expandVertexRule);
    BatchTransformationRule<ExpandOperatorMatch, ExpandOperatorMatcher> _expandOperatorRule = this.expandOperatorRule();
    statements.<ExpandOperatorMatch>fireWhilePossible(_expandOperatorRule);
    return container;
  }
  
  /**
   * Replace the GetVertexOperator + ExpandOperator pairs with a single GetEdgesOperator
   */
  protected BatchTransformationRule<ExpandVertexMatch, ExpandVertexMatcher> expandVertexRule() {
    try {
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ExpandVertexMatch, ExpandVertexMatcher> _createRule = this.ruleFactory.<ExpandVertexMatch, ExpandVertexMatcher>createRule();
      IQuerySpecification<ExpandVertexMatcher> _querySpecification = ExpandVertexMatcher.querySpecification();
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ExpandVertexMatch, ExpandVertexMatcher> _precondition = _createRule.precondition(_querySpecification);
      final IMatchProcessor<ExpandVertexMatch> _function = (ExpandVertexMatch it) -> {
        final ExpandOperator expandOperator = it.getExpandOperator();
        EdgeVariable _edgeVariable = expandOperator.getEdgeVariable();
        String _name = _edgeVariable.getName();
        String _plus = ("expandVertexRule fired for " + _name);
        this.log(_plus);
        GetEdgesOperator _createGetEdgesOperator = this.relalgFactory.createGetEdgesOperator();
        final Procedure1<GetEdgesOperator> _function_1 = (GetEdgesOperator it_1) -> {
          VertexVariable _source = this.source(expandOperator);
          it_1.setSourceVertexVariable(_source);
          VertexVariable _target = this.target(expandOperator);
          it_1.setTargetVertexVariable(_target);
          EdgeVariable _edgeVariable_1 = expandOperator.getEdgeVariable();
          it_1.setEdgeVariable(_edgeVariable_1);
        };
        final GetEdgesOperator getEdgesOperator = ObjectExtensions.<GetEdgesOperator>operator_doubleArrow(_createGetEdgesOperator, _function_1);
        Operator _parentOperator = it.getParentOperator();
        this.changeOperator(_parentOperator, expandOperator, getEdgesOperator);
      };
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ExpandVertexMatch, ExpandVertexMatcher> _action = _precondition.action(_function);
      return _action.build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Replace a single expand operator with a GetEdgesOperator and a JoinOperator
   */
  protected BatchTransformationRule<ExpandOperatorMatch, ExpandOperatorMatcher> expandOperatorRule() {
    try {
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ExpandOperatorMatch, ExpandOperatorMatcher> _createRule = this.ruleFactory.<ExpandOperatorMatch, ExpandOperatorMatcher>createRule();
      IQuerySpecification<ExpandOperatorMatcher> _querySpecification = ExpandOperatorMatcher.querySpecification();
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ExpandOperatorMatch, ExpandOperatorMatcher> _precondition = _createRule.precondition(_querySpecification);
      final IMatchProcessor<ExpandOperatorMatch> _function = (ExpandOperatorMatch it) -> {
        final ExpandOperator expandOperator = it.getExpandOperator();
        EdgeVariable _edgeVariable = expandOperator.getEdgeVariable();
        String _name = _edgeVariable.getName();
        String _plus = ("expandOperatorRule fired for " + _name);
        this.log(_plus);
        GetEdgesOperator _createGetEdgesOperator = this.relalgFactory.createGetEdgesOperator();
        final Procedure1<GetEdgesOperator> _function_1 = (GetEdgesOperator it_1) -> {
          VertexVariable _source = this.source(expandOperator);
          it_1.setSourceVertexVariable(_source);
          VertexVariable _target = this.target(expandOperator);
          it_1.setTargetVertexVariable(_target);
          EdgeVariable _edgeVariable_1 = expandOperator.getEdgeVariable();
          it_1.setEdgeVariable(_edgeVariable_1);
        };
        final GetEdgesOperator getEdgesOperator = ObjectExtensions.<GetEdgesOperator>operator_doubleArrow(_createGetEdgesOperator, _function_1);
        JoinOperator _createJoinOperator = this.relalgFactory.createJoinOperator();
        final Procedure1<JoinOperator> _function_2 = (JoinOperator it_1) -> {
          Operator _input = expandOperator.getInput();
          it_1.setLeftInput(_input);
          it_1.setRightInput(getEdgesOperator);
        };
        final JoinOperator joinOperator = ObjectExtensions.<JoinOperator>operator_doubleArrow(_createJoinOperator, _function_2);
        Operator _parentOperator = it.getParentOperator();
        this.changeOperator(_parentOperator, expandOperator, joinOperator);
      };
      BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ExpandOperatorMatch, ExpandOperatorMatcher> _action = _precondition.action(_function);
      return _action.build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
