package ingraph.optimization.transformations.cost;

import java.util.Arrays;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import relalg.AllDifferentOperator;
import relalg.AntiJoinOperator;
import relalg.Cardinality;
import relalg.GetEdgesOperator;
import relalg.GetVerticesOperator;
import relalg.JoinOperator;
import relalg.LeftOuterJoinOperator;
import relalg.Operator;
import relalg.ProductionOperator;
import relalg.ProjectionOperator;
import relalg.RelalgContainer;
import relalg.RelalgFactory;
import relalg.SelectionOperator;
import relalg.UnionOperator;

@SuppressWarnings("all")
public class ReteCostFunction {
  @Extension
  private final RelalgFactory factory = RelalgFactory.eINSTANCE;
  
  public RelalgContainer estimateCost(final RelalgContainer container) {
    Operator _rootExpression = container.getRootExpression();
    this.estimate(_rootExpression);
    return container;
  }
  
  public Double getEstimation(final RelalgContainer container) {
    Double _xblockexpression = null;
    {
      this.estimateCost(container);
      Operator _rootExpression = container.getRootExpression();
      Cardinality _cardinality = _rootExpression.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  /**
   * Nullary operators
   */
  protected Double _estimate(final GetVerticesOperator op) {
    Double _xblockexpression = null;
    {
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        it.setValue(Double.valueOf(10.0));
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  protected Double _estimate(final GetEdgesOperator op) {
    Double _xblockexpression = null;
    {
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        it.setValue(Double.valueOf(5.0));
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  /**
   * Unary operators
   */
  protected Double _estimate(final AllDifferentOperator op) {
    Operator _input = op.getInput();
    return this.estimate(_input);
  }
  
  protected Double _estimate(final SelectionOperator op) {
    Double _xblockexpression = null;
    {
      Operator _input = op.getInput();
      final Double inputEstimation = this.estimate(_input);
      final double currentEstimation = ((inputEstimation).doubleValue() / 10);
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        it.setValue(Double.valueOf(currentEstimation));
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  protected Double _estimate(final ProductionOperator op) {
    Double _xblockexpression = null;
    {
      Operator _input = op.getInput();
      this.estimate(_input);
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        Operator _input_1 = op.getInput();
        Cardinality _cardinality = _input_1.getCardinality();
        Double _value = _cardinality.getValue();
        it.setValue(_value);
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  protected Double _estimate(final ProjectionOperator op) {
    Double _xblockexpression = null;
    {
      Operator _input = op.getInput();
      this.estimate(_input);
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        Operator _input_1 = op.getInput();
        Cardinality _cardinality = _input_1.getCardinality();
        Double _value = _cardinality.getValue();
        it.setValue(_value);
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  /**
   * Binary operators
   */
  protected Double _estimate(final AntiJoinOperator op) {
    Double _xblockexpression = null;
    {
      Operator _leftInput = op.getLeftInput();
      this.estimate(_leftInput);
      Operator _rightInput = op.getRightInput();
      this.estimate(_rightInput);
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        Operator _leftInput_1 = op.getLeftInput();
        Cardinality _cardinality = _leftInput_1.getCardinality();
        Double _value = _cardinality.getValue();
        it.setValue(_value);
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  protected Double _estimate(final JoinOperator op) {
    Double _xblockexpression = null;
    {
      Operator _leftInput = op.getLeftInput();
      this.estimate(_leftInput);
      Operator _rightInput = op.getRightInput();
      this.estimate(_rightInput);
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        Operator _leftInput_1 = op.getLeftInput();
        Cardinality _cardinality = _leftInput_1.getCardinality();
        Double _value = _cardinality.getValue();
        Operator _rightInput_1 = op.getRightInput();
        Cardinality _cardinality_1 = _rightInput_1.getCardinality();
        Double _value_1 = _cardinality_1.getValue();
        double _multiply = DoubleExtensions.operator_multiply(_value, _value_1);
        double _divide = (_multiply / 100);
        it.setValue(Double.valueOf(_divide));
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  protected Double _estimate(final LeftOuterJoinOperator op) {
    Double _xblockexpression = null;
    {
      Operator _leftInput = op.getLeftInput();
      this.estimate(_leftInput);
      Operator _rightInput = op.getRightInput();
      this.estimate(_rightInput);
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        Operator _leftInput_1 = op.getLeftInput();
        Cardinality _cardinality = _leftInput_1.getCardinality();
        Double _value = _cardinality.getValue();
        it.setValue(_value);
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  protected Double _estimate(final UnionOperator op) {
    Double _xblockexpression = null;
    {
      Operator _leftInput = op.getLeftInput();
      this.estimate(_leftInput);
      Operator _rightInput = op.getRightInput();
      this.estimate(_rightInput);
      Cardinality _createCardinality = this.factory.createCardinality();
      final Procedure1<Cardinality> _function = (Cardinality it) -> {
        Operator _leftInput_1 = op.getLeftInput();
        Cardinality _cardinality = _leftInput_1.getCardinality();
        Double _value = _cardinality.getValue();
        Operator _rightInput_1 = op.getRightInput();
        Cardinality _cardinality_1 = _rightInput_1.getCardinality();
        Double _value_1 = _cardinality_1.getValue();
        double _plus = DoubleExtensions.operator_plus(_value, _value_1);
        it.setValue(Double.valueOf(_plus));
      };
      Cardinality _doubleArrow = ObjectExtensions.<Cardinality>operator_doubleArrow(_createCardinality, _function);
      op.setCardinality(_doubleArrow);
      Cardinality _cardinality = op.getCardinality();
      _xblockexpression = _cardinality.getValue();
    }
    return _xblockexpression;
  }
  
  public Double estimate(final Operator op) {
    if (op instanceof AntiJoinOperator) {
      return _estimate((AntiJoinOperator)op);
    } else if (op instanceof JoinOperator) {
      return _estimate((JoinOperator)op);
    } else if (op instanceof LeftOuterJoinOperator) {
      return _estimate((LeftOuterJoinOperator)op);
    } else if (op instanceof UnionOperator) {
      return _estimate((UnionOperator)op);
    } else if (op instanceof AllDifferentOperator) {
      return _estimate((AllDifferentOperator)op);
    } else if (op instanceof GetEdgesOperator) {
      return _estimate((GetEdgesOperator)op);
    } else if (op instanceof GetVerticesOperator) {
      return _estimate((GetVerticesOperator)op);
    } else if (op instanceof ProductionOperator) {
      return _estimate((ProductionOperator)op);
    } else if (op instanceof ProjectionOperator) {
      return _estimate((ProjectionOperator)op);
    } else if (op instanceof SelectionOperator) {
      return _estimate((SelectionOperator)op);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(op).toString());
    }
  }
}
