package ingraph.optimization.transformations;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformation;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformationStatements;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import relalg.BinaryOperator;
import relalg.Direction;
import relalg.ExpandOperator;
import relalg.Operator;
import relalg.RelalgContainer;
import relalg.RelalgFactory;
import relalg.UnaryOperator;
import relalg.VertexVariable;

@SuppressWarnings("all")
public abstract class AbstractRelalgTransformation {
  @Extension
  protected final RelalgFactory relalgFactory = RelalgFactory.eINSTANCE;
  
  @Extension
  protected final BatchTransformationRuleFactory ruleFactory = new BatchTransformationRuleFactory();
  
  public AbstractRelalgTransformation() {
    Logger _defaultLogger = ViatraQueryLoggingUtil.getDefaultLogger();
    _defaultLogger.setLevel(Level.OFF);
  }
  
  protected BatchTransformationStatements register(final RelalgContainer container) {
    try {
      final EMFScope scope = new EMFScope(container);
      final AdvancedViatraQueryEngine engine = AdvancedViatraQueryEngine.createUnmanagedEngine(scope);
      BatchTransformation.BatchTransformationBuilder _forEngine = BatchTransformation.forEngine(engine);
      final BatchTransformation transformation = _forEngine.build();
      final BatchTransformationStatements statements = transformation.getTransformationStatements();
      return statements;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected void changeOperator(final Operator parentOperator, final Operator currentOperator, final Operator newOperator) {
    boolean _matched = false;
    if (parentOperator instanceof UnaryOperator) {
      _matched=true;
      ((UnaryOperator)parentOperator).setInput(newOperator);
    }
    if (!_matched) {
      if (parentOperator instanceof BinaryOperator) {
        _matched=true;
        Operator _leftInput = ((BinaryOperator)parentOperator).getLeftInput();
        boolean _equals = _leftInput.equals(currentOperator);
        if (_equals) {
          ((BinaryOperator)parentOperator).setLeftInput(newOperator);
        }
        Operator _rightInput = ((BinaryOperator)parentOperator).getRightInput();
        boolean _equals_1 = _rightInput.equals(currentOperator);
        if (_equals_1) {
          ((BinaryOperator)parentOperator).setRightInput(newOperator);
        }
      }
    }
    if ((currentOperator instanceof ExpandOperator)) {
      EcoreUtil2.delete(currentOperator);
    }
  }
  
  protected VertexVariable source(final ExpandOperator expandOperator) {
    Direction _direction = expandOperator.getDirection();
    if (_direction != null) {
      switch (_direction) {
        case BOTH:
        case IN:
          return expandOperator.getTargetVertexVariable();
        case OUT:
          return expandOperator.getSourceVertexVariable();
        default:
          break;
      }
    }
    return null;
  }
  
  protected VertexVariable target(final ExpandOperator expandOperator) {
    Direction _direction = expandOperator.getDirection();
    if (_direction != null) {
      switch (_direction) {
        case BOTH:
        case IN:
          return expandOperator.getSourceVertexVariable();
        case OUT:
          return expandOperator.getTargetVertexVariable();
        default:
          break;
      }
    }
    return null;
  }
}
