package ingraph.optimization.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import relalg.AllDifferentOperator;
import relalg.AntiJoinOperator;
import relalg.ArithmeticComparisonExpression;
import relalg.ArithmeticComparisonOperator;
import relalg.AttributeVariable;
import relalg.Direction;
import relalg.DuplicateEliminationOperator;
import relalg.EdgeLabel;
import relalg.EdgeVariable;
import relalg.ExpandOperator;
import relalg.GetVerticesOperator;
import relalg.IntegerLiteral;
import relalg.ProductionOperator;
import relalg.ProjectionOperator;
import relalg.RelalgContainer;
import relalg.RelalgFactory;
import relalg.SelectionOperator;
import relalg.StringLiteral;
import relalg.Variable;
import relalg.VertexLabel;
import relalg.VertexVariable;

@SuppressWarnings("all")
public class TrainBenchmarkUtil {
  @Extension
  private final static RelalgFactory factory = RelalgFactory.eINSTANCE;
  
  public static RelalgContainer posLength() {
    RelalgContainer _xblockexpression = null;
    {
      final RelalgContainer posLength = TrainBenchmarkUtil.factory.createRelalgContainer();
      VertexLabel _createVertexLabel = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function = (VertexLabel it) -> {
        it.setName("Segment");
        it.setContainer(posLength);
      };
      final VertexLabel segmentLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel, _function);
      VertexVariable _createVertexVariable = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_1 = (VertexVariable it) -> {
        it.setName("segment");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(segmentLabel);
        it.setContainer(posLength);
      };
      final VertexVariable segment = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable, _function_1);
      AttributeVariable _createAttributeVariable = TrainBenchmarkUtil.factory.createAttributeVariable();
      final Procedure1<AttributeVariable> _function_2 = (AttributeVariable it) -> {
        it.setName("length");
        it.setElement(segment);
        it.setContainer(posLength);
      };
      final AttributeVariable length = ObjectExtensions.<AttributeVariable>operator_doubleArrow(_createAttributeVariable, _function_2);
      GetVerticesOperator _createGetVerticesOperator = TrainBenchmarkUtil.factory.createGetVerticesOperator();
      final Procedure1<GetVerticesOperator> _function_3 = (GetVerticesOperator it) -> {
        it.setVertexVariable(segment);
      };
      final GetVerticesOperator getVertices = ObjectExtensions.<GetVerticesOperator>operator_doubleArrow(_createGetVerticesOperator, _function_3);
      IntegerLiteral _createIntegerLiteral = TrainBenchmarkUtil.factory.createIntegerLiteral();
      final Procedure1<IntegerLiteral> _function_4 = (IntegerLiteral it) -> {
        it.setValue(Integer.valueOf(0));
      };
      final IntegerLiteral integerLiteral0 = ObjectExtensions.<IntegerLiteral>operator_doubleArrow(_createIntegerLiteral, _function_4);
      ArithmeticComparisonExpression _createArithmeticComparisonExpression = TrainBenchmarkUtil.factory.createArithmeticComparisonExpression();
      final Procedure1<ArithmeticComparisonExpression> _function_5 = (ArithmeticComparisonExpression it) -> {
        it.setLeftOperand(length);
        it.setRightOperand(integerLiteral0);
        it.setOperator(ArithmeticComparisonOperator.LESS_THAN_OR_EQUAL);
      };
      final ArithmeticComparisonExpression condition = ObjectExtensions.<ArithmeticComparisonExpression>operator_doubleArrow(_createArithmeticComparisonExpression, _function_5);
      SelectionOperator _createSelectionOperator = TrainBenchmarkUtil.factory.createSelectionOperator();
      final Procedure1<SelectionOperator> _function_6 = (SelectionOperator it) -> {
        it.setInput(getVertices);
        it.setConditionString("segment.length <= 0");
        it.setCondition(condition);
      };
      final SelectionOperator filter1 = ObjectExtensions.<SelectionOperator>operator_doubleArrow(_createSelectionOperator, _function_6);
      ProjectionOperator _createProjectionOperator = TrainBenchmarkUtil.factory.createProjectionOperator();
      final Procedure1<ProjectionOperator> _function_7 = (ProjectionOperator it) -> {
        it.setInput(filter1);
        EList<Variable> _variables = it.getVariables();
        _variables.addAll(Collections.<Variable>unmodifiableList(CollectionLiterals.<Variable>newArrayList(segment, length)));
      };
      final ProjectionOperator projection = ObjectExtensions.<ProjectionOperator>operator_doubleArrow(_createProjectionOperator, _function_7);
      DuplicateEliminationOperator _createDuplicateEliminationOperator = TrainBenchmarkUtil.factory.createDuplicateEliminationOperator();
      final Procedure1<DuplicateEliminationOperator> _function_8 = (DuplicateEliminationOperator it) -> {
        it.setInput(projection);
      };
      final DuplicateEliminationOperator de = ObjectExtensions.<DuplicateEliminationOperator>operator_doubleArrow(_createDuplicateEliminationOperator, _function_8);
      ProductionOperator _createProductionOperator = TrainBenchmarkUtil.factory.createProductionOperator();
      final Procedure1<ProductionOperator> _function_9 = (ProductionOperator it) -> {
        it.setInput(de);
      };
      final ProductionOperator production = ObjectExtensions.<ProductionOperator>operator_doubleArrow(_createProductionOperator, _function_9);
      posLength.setRootExpression(production);
      _xblockexpression = posLength;
    }
    return _xblockexpression;
  }
  
  public static RelalgContainer routeSensor() {
    RelalgContainer _xblockexpression = null;
    {
      final RelalgContainer routeSensor = TrainBenchmarkUtil.factory.createRelalgContainer();
      VertexLabel _createVertexLabel = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function = (VertexLabel it) -> {
        it.setName("Route");
        it.setContainer(routeSensor);
      };
      final VertexLabel routeLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel, _function);
      VertexLabel _createVertexLabel_1 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_1 = (VertexLabel it) -> {
        it.setName("Sensor");
        it.setContainer(routeSensor);
      };
      final VertexLabel sensorLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_1, _function_1);
      VertexLabel _createVertexLabel_2 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_2 = (VertexLabel it) -> {
        it.setName("Switch");
        it.setContainer(routeSensor);
      };
      final VertexLabel switchLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_2, _function_2);
      VertexLabel _createVertexLabel_3 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_3 = (VertexLabel it) -> {
        it.setName("SwitchPosition");
        it.setContainer(routeSensor);
      };
      final VertexLabel switchPositionLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_3, _function_3);
      EdgeLabel _createEdgeLabel = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_4 = (EdgeLabel it) -> {
        it.setName("follows");
        it.setContainer(routeSensor);
      };
      final EdgeLabel followsLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel, _function_4);
      EdgeLabel _createEdgeLabel_1 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_5 = (EdgeLabel it) -> {
        it.setName("gathers");
        it.setContainer(routeSensor);
      };
      final EdgeLabel gathersLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_1, _function_5);
      EdgeLabel _createEdgeLabel_2 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_6 = (EdgeLabel it) -> {
        it.setName("monitoredBy");
        it.setContainer(routeSensor);
      };
      final EdgeLabel monitoredByLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_2, _function_6);
      EdgeLabel _createEdgeLabel_3 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_7 = (EdgeLabel it) -> {
        it.setName("target");
        it.setContainer(routeSensor);
      };
      final EdgeLabel targetLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_3, _function_7);
      VertexVariable _createVertexVariable = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_8 = (VertexVariable it) -> {
        it.setName("route");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(routeLabel);
        it.setContainer(routeSensor);
      };
      final VertexVariable route = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable, _function_8);
      VertexVariable _createVertexVariable_1 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_9 = (VertexVariable it) -> {
        it.setName("sw");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(switchLabel);
        it.setContainer(routeSensor);
      };
      final VertexVariable sw = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_1, _function_9);
      VertexVariable _createVertexVariable_2 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_10 = (VertexVariable it) -> {
        it.setName("swP");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(switchPositionLabel);
        it.setContainer(routeSensor);
      };
      final VertexVariable swP = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_2, _function_10);
      VertexVariable _createVertexVariable_3 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_11 = (VertexVariable it) -> {
        it.setName("sensor");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(sensorLabel);
        it.setContainer(routeSensor);
      };
      final VertexVariable sensor = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_3, _function_11);
      EdgeVariable _createEdgeVariable = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_12 = (EdgeVariable it) -> {
        it.setName("_e1");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(followsLabel);
        it.setDontCare(true);
        it.setContainer(routeSensor);
      };
      final EdgeVariable _e1 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable, _function_12);
      EdgeVariable _createEdgeVariable_1 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_13 = (EdgeVariable it) -> {
        it.setName("_e2");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(targetLabel);
        it.setDontCare(true);
        it.setContainer(routeSensor);
      };
      final EdgeVariable _e2 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_1, _function_13);
      EdgeVariable _createEdgeVariable_2 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_14 = (EdgeVariable it) -> {
        it.setName("_e3");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(monitoredByLabel);
        it.setDontCare(true);
        it.setContainer(routeSensor);
      };
      final EdgeVariable _e3 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_2, _function_14);
      EdgeVariable _createEdgeVariable_3 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_15 = (EdgeVariable it) -> {
        it.setName("_e4");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(gathersLabel);
        it.setDontCare(true);
        it.setContainer(routeSensor);
      };
      final EdgeVariable _e4 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_3, _function_15);
      GetVerticesOperator _createGetVerticesOperator = TrainBenchmarkUtil.factory.createGetVerticesOperator();
      final Procedure1<GetVerticesOperator> _function_16 = (GetVerticesOperator it) -> {
        it.setVertexVariable(route);
      };
      final GetVerticesOperator getVerticesRoute1 = ObjectExtensions.<GetVerticesOperator>operator_doubleArrow(_createGetVerticesOperator, _function_16);
      GetVerticesOperator _createGetVerticesOperator_1 = TrainBenchmarkUtil.factory.createGetVerticesOperator();
      final Procedure1<GetVerticesOperator> _function_17 = (GetVerticesOperator it) -> {
        it.setVertexVariable(route);
      };
      final GetVerticesOperator getVerticesRoute2 = ObjectExtensions.<GetVerticesOperator>operator_doubleArrow(_createGetVerticesOperator_1, _function_17);
      ExpandOperator _createExpandOperator = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_18 = (ExpandOperator it) -> {
        it.setInput(getVerticesRoute1);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(route);
        it.setTargetVertexVariable(swP);
        it.setEdgeVariable(_e1);
      };
      final ExpandOperator expand1 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator, _function_18);
      ExpandOperator _createExpandOperator_1 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_19 = (ExpandOperator it) -> {
        it.setInput(expand1);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(swP);
        it.setTargetVertexVariable(sw);
        it.setEdgeVariable(_e2);
      };
      final ExpandOperator expand2 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_1, _function_19);
      ExpandOperator _createExpandOperator_2 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_20 = (ExpandOperator it) -> {
        it.setInput(expand2);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(sw);
        it.setTargetVertexVariable(sensor);
        it.setEdgeVariable(_e3);
      };
      final ExpandOperator expand3 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_2, _function_20);
      AllDifferentOperator _createAllDifferentOperator = TrainBenchmarkUtil.factory.createAllDifferentOperator();
      final Procedure1<AllDifferentOperator> _function_21 = (AllDifferentOperator it) -> {
        it.setInput(expand3);
        EList<EdgeVariable> _edgeVariables = it.getEdgeVariables();
        _edgeVariables.addAll(Collections.<EdgeVariable>unmodifiableList(CollectionLiterals.<EdgeVariable>newArrayList(_e1, _e2, _e3)));
      };
      final AllDifferentOperator allDifferent = ObjectExtensions.<AllDifferentOperator>operator_doubleArrow(_createAllDifferentOperator, _function_21);
      ExpandOperator _createExpandOperator_3 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_22 = (ExpandOperator it) -> {
        it.setInput(getVerticesRoute2);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(route);
        it.setTargetVertexVariable(sensor);
        it.setEdgeVariable(_e4);
      };
      final ExpandOperator expand4 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_3, _function_22);
      AntiJoinOperator _createAntiJoinOperator = TrainBenchmarkUtil.factory.createAntiJoinOperator();
      final Procedure1<AntiJoinOperator> _function_23 = (AntiJoinOperator it) -> {
        it.setLeftInput(allDifferent);
        it.setRightInput(expand4);
      };
      final AntiJoinOperator antiJoin = ObjectExtensions.<AntiJoinOperator>operator_doubleArrow(_createAntiJoinOperator, _function_23);
      ProjectionOperator _createProjectionOperator = TrainBenchmarkUtil.factory.createProjectionOperator();
      final Procedure1<ProjectionOperator> _function_24 = (ProjectionOperator it) -> {
        it.setInput(antiJoin);
        EList<Variable> _variables = it.getVariables();
        List<VertexVariable> _asList = Arrays.<VertexVariable>asList(route, sensor, swP, sw);
        _variables.addAll(_asList);
      };
      final ProjectionOperator projection = ObjectExtensions.<ProjectionOperator>operator_doubleArrow(_createProjectionOperator, _function_24);
      DuplicateEliminationOperator _createDuplicateEliminationOperator = TrainBenchmarkUtil.factory.createDuplicateEliminationOperator();
      final Procedure1<DuplicateEliminationOperator> _function_25 = (DuplicateEliminationOperator it) -> {
        it.setInput(projection);
      };
      final DuplicateEliminationOperator de = ObjectExtensions.<DuplicateEliminationOperator>operator_doubleArrow(_createDuplicateEliminationOperator, _function_25);
      ProductionOperator _createProductionOperator = TrainBenchmarkUtil.factory.createProductionOperator();
      final Procedure1<ProductionOperator> _function_26 = (ProductionOperator it) -> {
        it.setInput(de);
      };
      final ProductionOperator production = ObjectExtensions.<ProductionOperator>operator_doubleArrow(_createProductionOperator, _function_26);
      routeSensor.setRootExpression(production);
      _xblockexpression = routeSensor;
    }
    return _xblockexpression;
  }
  
  public static RelalgContainer semaphoreNeighbor() {
    RelalgContainer _xblockexpression = null;
    {
      final RelalgContainer semaphoreNeighbor = TrainBenchmarkUtil.factory.createRelalgContainer();
      VertexLabel _createVertexLabel = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function = (VertexLabel it) -> {
        it.setName("Route");
        it.setContainer(semaphoreNeighbor);
      };
      final VertexLabel routeLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel, _function);
      VertexLabel _createVertexLabel_1 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_1 = (VertexLabel it) -> {
        it.setName("Semaphore");
        it.setContainer(semaphoreNeighbor);
      };
      final VertexLabel semaphoreLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_1, _function_1);
      VertexLabel _createVertexLabel_2 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_2 = (VertexLabel it) -> {
        it.setName("Sensor");
        it.setContainer(semaphoreNeighbor);
      };
      final VertexLabel sensorLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_2, _function_2);
      EdgeLabel _createEdgeLabel = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_3 = (EdgeLabel it) -> {
        it.setName("connectsTo");
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeLabel connectsToLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel, _function_3);
      EdgeLabel _createEdgeLabel_1 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_4 = (EdgeLabel it) -> {
        it.setName("entry");
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeLabel entryLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_1, _function_4);
      EdgeLabel _createEdgeLabel_2 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_5 = (EdgeLabel it) -> {
        it.setName("exit");
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeLabel exitLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_2, _function_5);
      EdgeLabel _createEdgeLabel_3 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_6 = (EdgeLabel it) -> {
        it.setName("gathers");
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeLabel gathersLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_3, _function_6);
      EdgeLabel _createEdgeLabel_4 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_7 = (EdgeLabel it) -> {
        it.setName("monitoredBy");
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeLabel monitoredByLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_4, _function_7);
      VertexVariable _createVertexVariable = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_8 = (VertexVariable it) -> {
        it.setName("route1");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(routeLabel);
        it.setContainer(semaphoreNeighbor);
      };
      final VertexVariable route1 = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable, _function_8);
      VertexVariable _createVertexVariable_1 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_9 = (VertexVariable it) -> {
        it.setName("route2");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(routeLabel);
        it.setContainer(semaphoreNeighbor);
      };
      final VertexVariable route2 = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_1, _function_9);
      VertexVariable _createVertexVariable_2 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_10 = (VertexVariable it) -> {
        it.setName("semaphore");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(semaphoreLabel);
        it.setContainer(semaphoreNeighbor);
      };
      final VertexVariable semaphore = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_2, _function_10);
      VertexVariable _createVertexVariable_3 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_11 = (VertexVariable it) -> {
        it.setName("sensor1");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(sensorLabel);
        it.setContainer(semaphoreNeighbor);
      };
      final VertexVariable sensor1 = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_3, _function_11);
      VertexVariable _createVertexVariable_4 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_12 = (VertexVariable it) -> {
        it.setName("sensor");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(sensorLabel);
        it.setContainer(semaphoreNeighbor);
      };
      final VertexVariable sensor2 = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_4, _function_12);
      VertexVariable _createVertexVariable_5 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_13 = (VertexVariable it) -> {
        it.setName("te1");
        it.setContainer(semaphoreNeighbor);
      };
      final VertexVariable te1 = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_5, _function_13);
      VertexVariable _createVertexVariable_6 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_14 = (VertexVariable it) -> {
        it.setName("te2");
        it.setContainer(semaphoreNeighbor);
      };
      final VertexVariable te2 = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_6, _function_14);
      EdgeVariable _createEdgeVariable = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_15 = (EdgeVariable it) -> {
        it.setName("_e1");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(exitLabel);
        it.setDontCare(true);
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeVariable _e1 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable, _function_15);
      EdgeVariable _createEdgeVariable_1 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_16 = (EdgeVariable it) -> {
        it.setName("_e2");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(gathersLabel);
        it.setDontCare(true);
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeVariable _e2 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_1, _function_16);
      EdgeVariable _createEdgeVariable_2 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_17 = (EdgeVariable it) -> {
        it.setName("_e3");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(monitoredByLabel);
        it.setDontCare(true);
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeVariable _e3 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_2, _function_17);
      EdgeVariable _createEdgeVariable_3 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_18 = (EdgeVariable it) -> {
        it.setName("_e4");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(connectsToLabel);
        it.setDontCare(true);
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeVariable _e4 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_3, _function_18);
      EdgeVariable _createEdgeVariable_4 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_19 = (EdgeVariable it) -> {
        it.setName("_e5");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(monitoredByLabel);
        it.setDontCare(true);
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeVariable _e5 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_4, _function_19);
      EdgeVariable _createEdgeVariable_5 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_20 = (EdgeVariable it) -> {
        it.setName("_e6");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(gathersLabel);
        it.setDontCare(true);
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeVariable _e6 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_5, _function_20);
      EdgeVariable _createEdgeVariable_6 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_21 = (EdgeVariable it) -> {
        it.setName("_e7");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(entryLabel);
        it.setDontCare(true);
        it.setContainer(semaphoreNeighbor);
      };
      final EdgeVariable _e7 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_6, _function_21);
      GetVerticesOperator _createGetVerticesOperator = TrainBenchmarkUtil.factory.createGetVerticesOperator();
      final Procedure1<GetVerticesOperator> _function_22 = (GetVerticesOperator it) -> {
        it.setVertexVariable(semaphore);
      };
      final GetVerticesOperator getVertices1 = ObjectExtensions.<GetVerticesOperator>operator_doubleArrow(_createGetVerticesOperator, _function_22);
      GetVerticesOperator _createGetVerticesOperator_1 = TrainBenchmarkUtil.factory.createGetVerticesOperator();
      final Procedure1<GetVerticesOperator> _function_23 = (GetVerticesOperator it) -> {
        it.setVertexVariable(semaphore);
      };
      final GetVerticesOperator getVertices2 = ObjectExtensions.<GetVerticesOperator>operator_doubleArrow(_createGetVerticesOperator_1, _function_23);
      ExpandOperator _createExpandOperator = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_24 = (ExpandOperator it) -> {
        it.setInput(getVertices1);
        it.setDirection(Direction.IN);
        it.setSourceVertexVariable(semaphore);
        it.setTargetVertexVariable(route1);
        it.setEdgeVariable(_e1);
      };
      final ExpandOperator expand1 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator, _function_24);
      ExpandOperator _createExpandOperator_1 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_25 = (ExpandOperator it) -> {
        it.setInput(expand1);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(route1);
        it.setTargetVertexVariable(sensor1);
        it.setEdgeVariable(_e2);
      };
      final ExpandOperator expand2 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_1, _function_25);
      ExpandOperator _createExpandOperator_2 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_26 = (ExpandOperator it) -> {
        it.setInput(expand2);
        it.setDirection(Direction.IN);
        it.setSourceVertexVariable(sensor1);
        it.setTargetVertexVariable(te1);
        it.setEdgeVariable(_e3);
      };
      final ExpandOperator expand3 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_2, _function_26);
      ExpandOperator _createExpandOperator_3 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_27 = (ExpandOperator it) -> {
        it.setInput(expand3);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(te1);
        it.setTargetVertexVariable(te2);
        it.setEdgeVariable(_e4);
      };
      final ExpandOperator expand4 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_3, _function_27);
      ExpandOperator _createExpandOperator_4 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_28 = (ExpandOperator it) -> {
        it.setInput(expand4);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(te2);
        it.setTargetVertexVariable(sensor2);
        it.setEdgeVariable(_e5);
      };
      final ExpandOperator expand5 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_4, _function_28);
      ExpandOperator _createExpandOperator_5 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_29 = (ExpandOperator it) -> {
        it.setInput(expand5);
        it.setDirection(Direction.IN);
        it.setSourceVertexVariable(sensor2);
        it.setTargetVertexVariable(route2);
        it.setEdgeVariable(_e6);
      };
      final ExpandOperator expand6 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_5, _function_29);
      AllDifferentOperator _createAllDifferentOperator = TrainBenchmarkUtil.factory.createAllDifferentOperator();
      final Procedure1<AllDifferentOperator> _function_30 = (AllDifferentOperator it) -> {
        it.setInput(expand6);
        EList<EdgeVariable> _edgeVariables = it.getEdgeVariables();
        List<EdgeVariable> _asList = Arrays.<EdgeVariable>asList(_e1, _e2, _e3, _e4, _e5, _e6);
        _edgeVariables.addAll(_asList);
      };
      final AllDifferentOperator allDifferent = ObjectExtensions.<AllDifferentOperator>operator_doubleArrow(_createAllDifferentOperator, _function_30);
      ExpandOperator _createExpandOperator_6 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_31 = (ExpandOperator it) -> {
        it.setInput(getVertices2);
        it.setDirection(Direction.IN);
        it.setSourceVertexVariable(semaphore);
        it.setTargetVertexVariable(route2);
        it.setEdgeVariable(_e7);
      };
      final ExpandOperator expand7 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_6, _function_31);
      AntiJoinOperator _createAntiJoinOperator = TrainBenchmarkUtil.factory.createAntiJoinOperator();
      final Procedure1<AntiJoinOperator> _function_32 = (AntiJoinOperator it) -> {
        it.setLeftInput(allDifferent);
        it.setRightInput(expand7);
      };
      final AntiJoinOperator antiJoin = ObjectExtensions.<AntiJoinOperator>operator_doubleArrow(_createAntiJoinOperator, _function_32);
      ArithmeticComparisonExpression _createArithmeticComparisonExpression = TrainBenchmarkUtil.factory.createArithmeticComparisonExpression();
      final Procedure1<ArithmeticComparisonExpression> _function_33 = (ArithmeticComparisonExpression it) -> {
        it.setLeftOperand(route1);
        it.setRightOperand(route2);
        it.setOperator(ArithmeticComparisonOperator.NOT_EQUAL_TO);
      };
      final ArithmeticComparisonExpression condition = ObjectExtensions.<ArithmeticComparisonExpression>operator_doubleArrow(_createArithmeticComparisonExpression, _function_33);
      SelectionOperator _createSelectionOperator = TrainBenchmarkUtil.factory.createSelectionOperator();
      final Procedure1<SelectionOperator> _function_34 = (SelectionOperator it) -> {
        it.setInput(antiJoin);
        it.setConditionString("route1 != route2");
        it.setCondition(condition);
      };
      final SelectionOperator filter = ObjectExtensions.<SelectionOperator>operator_doubleArrow(_createSelectionOperator, _function_34);
      ProjectionOperator _createProjectionOperator = TrainBenchmarkUtil.factory.createProjectionOperator();
      final Procedure1<ProjectionOperator> _function_35 = (ProjectionOperator it) -> {
        it.setInput(filter);
        EList<Variable> _variables = it.getVariables();
        List<VertexVariable> _asList = Arrays.<VertexVariable>asList(semaphore, route1, route2, sensor1, sensor2, te1, te2);
        _variables.addAll(_asList);
      };
      final ProjectionOperator projection = ObjectExtensions.<ProjectionOperator>operator_doubleArrow(_createProjectionOperator, _function_35);
      DuplicateEliminationOperator _createDuplicateEliminationOperator = TrainBenchmarkUtil.factory.createDuplicateEliminationOperator();
      final Procedure1<DuplicateEliminationOperator> _function_36 = (DuplicateEliminationOperator it) -> {
        it.setInput(projection);
      };
      final DuplicateEliminationOperator de = ObjectExtensions.<DuplicateEliminationOperator>operator_doubleArrow(_createDuplicateEliminationOperator, _function_36);
      ProductionOperator _createProductionOperator = TrainBenchmarkUtil.factory.createProductionOperator();
      final Procedure1<ProductionOperator> _function_37 = (ProductionOperator it) -> {
        it.setInput(de);
      };
      final ProductionOperator production = ObjectExtensions.<ProductionOperator>operator_doubleArrow(_createProductionOperator, _function_37);
      semaphoreNeighbor.setRootExpression(production);
      _xblockexpression = semaphoreNeighbor;
    }
    return _xblockexpression;
  }
  
  public static RelalgContainer switchMonitored() {
    RelalgContainer _xblockexpression = null;
    {
      final RelalgContainer switchMonitored = TrainBenchmarkUtil.factory.createRelalgContainer();
      VertexLabel _createVertexLabel = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function = (VertexLabel it) -> {
        it.setName("Sensor");
        it.setContainer(switchMonitored);
      };
      final VertexLabel sensorLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel, _function);
      VertexLabel _createVertexLabel_1 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_1 = (VertexLabel it) -> {
        it.setName("Switch");
        it.setContainer(switchMonitored);
      };
      final VertexLabel switchLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_1, _function_1);
      EdgeLabel _createEdgeLabel = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_2 = (EdgeLabel it) -> {
        it.setName("monitoredBy");
        it.setContainer(switchMonitored);
      };
      final EdgeLabel monitoredByLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel, _function_2);
      VertexVariable _createVertexVariable = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_3 = (VertexVariable it) -> {
        it.setName("sw");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(switchLabel);
        it.setContainer(switchMonitored);
      };
      final VertexVariable sw = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable, _function_3);
      VertexVariable _createVertexVariable_1 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_4 = (VertexVariable it) -> {
        it.setName("_sensor");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(sensorLabel);
        it.setDontCare(true);
        it.setContainer(switchMonitored);
      };
      final VertexVariable _sensor = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_1, _function_4);
      EdgeVariable _createEdgeVariable = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_5 = (EdgeVariable it) -> {
        it.setName("_e1");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(monitoredByLabel);
        it.setDontCare(true);
        it.setContainer(switchMonitored);
      };
      final EdgeVariable _e1 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable, _function_5);
      GetVerticesOperator _createGetVerticesOperator = TrainBenchmarkUtil.factory.createGetVerticesOperator();
      final Procedure1<GetVerticesOperator> _function_6 = (GetVerticesOperator it) -> {
        it.setVertexVariable(sw);
      };
      final GetVerticesOperator getVertices1 = ObjectExtensions.<GetVerticesOperator>operator_doubleArrow(_createGetVerticesOperator, _function_6);
      GetVerticesOperator _createGetVerticesOperator_1 = TrainBenchmarkUtil.factory.createGetVerticesOperator();
      final Procedure1<GetVerticesOperator> _function_7 = (GetVerticesOperator it) -> {
        it.setVertexVariable(sw);
      };
      final GetVerticesOperator getVertices2 = ObjectExtensions.<GetVerticesOperator>operator_doubleArrow(_createGetVerticesOperator_1, _function_7);
      ExpandOperator _createExpandOperator = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_8 = (ExpandOperator it) -> {
        it.setInput(getVertices2);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(sw);
        it.setTargetVertexVariable(_sensor);
        it.setEdgeVariable(_e1);
      };
      final ExpandOperator expand1 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator, _function_8);
      AntiJoinOperator _createAntiJoinOperator = TrainBenchmarkUtil.factory.createAntiJoinOperator();
      final Procedure1<AntiJoinOperator> _function_9 = (AntiJoinOperator it) -> {
        it.setLeftInput(getVertices1);
        it.setRightInput(expand1);
      };
      final AntiJoinOperator antiJoin = ObjectExtensions.<AntiJoinOperator>operator_doubleArrow(_createAntiJoinOperator, _function_9);
      DuplicateEliminationOperator _createDuplicateEliminationOperator = TrainBenchmarkUtil.factory.createDuplicateEliminationOperator();
      final Procedure1<DuplicateEliminationOperator> _function_10 = (DuplicateEliminationOperator it) -> {
        it.setInput(antiJoin);
      };
      final DuplicateEliminationOperator de = ObjectExtensions.<DuplicateEliminationOperator>operator_doubleArrow(_createDuplicateEliminationOperator, _function_10);
      ProductionOperator _createProductionOperator = TrainBenchmarkUtil.factory.createProductionOperator();
      final Procedure1<ProductionOperator> _function_11 = (ProductionOperator it) -> {
        it.setInput(de);
      };
      final ProductionOperator production = ObjectExtensions.<ProductionOperator>operator_doubleArrow(_createProductionOperator, _function_11);
      switchMonitored.setRootExpression(production);
      _xblockexpression = switchMonitored;
    }
    return _xblockexpression;
  }
  
  public static RelalgContainer switchSet() {
    RelalgContainer _xblockexpression = null;
    {
      final RelalgContainer switchSet = TrainBenchmarkUtil.factory.createRelalgContainer();
      VertexLabel _createVertexLabel = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function = (VertexLabel it) -> {
        it.setName("Route");
        it.setContainer(switchSet);
      };
      final VertexLabel routeLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel, _function);
      VertexLabel _createVertexLabel_1 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_1 = (VertexLabel it) -> {
        it.setName("Semaphore");
        it.setContainer(switchSet);
      };
      final VertexLabel semaphoreLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_1, _function_1);
      VertexLabel _createVertexLabel_2 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_2 = (VertexLabel it) -> {
        it.setName("Switch");
        it.setContainer(switchSet);
      };
      final VertexLabel switchLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_2, _function_2);
      VertexLabel _createVertexLabel_3 = TrainBenchmarkUtil.factory.createVertexLabel();
      final Procedure1<VertexLabel> _function_3 = (VertexLabel it) -> {
        it.setName("SwitchPosition");
        it.setContainer(switchSet);
      };
      final VertexLabel switchPositionLabel = ObjectExtensions.<VertexLabel>operator_doubleArrow(_createVertexLabel_3, _function_3);
      EdgeLabel _createEdgeLabel = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_4 = (EdgeLabel it) -> {
        it.setName("entry");
        it.setContainer(switchSet);
      };
      final EdgeLabel entryLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel, _function_4);
      EdgeLabel _createEdgeLabel_1 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_5 = (EdgeLabel it) -> {
        it.setName("follows");
        it.setContainer(switchSet);
      };
      final EdgeLabel followsLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_1, _function_5);
      EdgeLabel _createEdgeLabel_2 = TrainBenchmarkUtil.factory.createEdgeLabel();
      final Procedure1<EdgeLabel> _function_6 = (EdgeLabel it) -> {
        it.setName("target");
        it.setContainer(switchSet);
      };
      final EdgeLabel targetLabel = ObjectExtensions.<EdgeLabel>operator_doubleArrow(_createEdgeLabel_2, _function_6);
      VertexVariable _createVertexVariable = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_7 = (VertexVariable it) -> {
        it.setName("route");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(routeLabel);
        it.setContainer(switchSet);
      };
      final VertexVariable route = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable, _function_7);
      VertexVariable _createVertexVariable_1 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_8 = (VertexVariable it) -> {
        it.setName("sw");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(switchLabel);
        it.setContainer(switchSet);
      };
      final VertexVariable sw = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_1, _function_8);
      VertexVariable _createVertexVariable_2 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_9 = (VertexVariable it) -> {
        it.setName("swP");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(switchPositionLabel);
        it.setContainer(switchSet);
      };
      final VertexVariable swP = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_2, _function_9);
      VertexVariable _createVertexVariable_3 = TrainBenchmarkUtil.factory.createVertexVariable();
      final Procedure1<VertexVariable> _function_10 = (VertexVariable it) -> {
        it.setName("semaphore");
        EList<VertexLabel> _vertexLabels = it.getVertexLabels();
        _vertexLabels.add(semaphoreLabel);
        it.setContainer(switchSet);
      };
      final VertexVariable semaphore = ObjectExtensions.<VertexVariable>operator_doubleArrow(_createVertexVariable_3, _function_10);
      AttributeVariable _createAttributeVariable = TrainBenchmarkUtil.factory.createAttributeVariable();
      final Procedure1<AttributeVariable> _function_11 = (AttributeVariable it) -> {
        it.setName("currentPosition");
        it.setElement(sw);
        it.setContainer(switchSet);
      };
      final AttributeVariable currentPosition = ObjectExtensions.<AttributeVariable>operator_doubleArrow(_createAttributeVariable, _function_11);
      AttributeVariable _createAttributeVariable_1 = TrainBenchmarkUtil.factory.createAttributeVariable();
      final Procedure1<AttributeVariable> _function_12 = (AttributeVariable it) -> {
        it.setName("position");
        it.setElement(swP);
        it.setContainer(switchSet);
      };
      final AttributeVariable position = ObjectExtensions.<AttributeVariable>operator_doubleArrow(_createAttributeVariable_1, _function_12);
      AttributeVariable _createAttributeVariable_2 = TrainBenchmarkUtil.factory.createAttributeVariable();
      final Procedure1<AttributeVariable> _function_13 = (AttributeVariable it) -> {
        it.setName("signal");
        it.setElement(semaphore);
        it.setContainer(switchSet);
      };
      final AttributeVariable signal = ObjectExtensions.<AttributeVariable>operator_doubleArrow(_createAttributeVariable_2, _function_13);
      EdgeVariable _createEdgeVariable = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_14 = (EdgeVariable it) -> {
        it.setName("_e1");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(entryLabel);
        it.setDontCare(true);
        it.setContainer(switchSet);
      };
      final EdgeVariable _e1 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable, _function_14);
      EdgeVariable _createEdgeVariable_1 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_15 = (EdgeVariable it) -> {
        it.setName("_e2");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(followsLabel);
        it.setDontCare(true);
        it.setContainer(switchSet);
      };
      final EdgeVariable _e2 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_1, _function_15);
      EdgeVariable _createEdgeVariable_2 = TrainBenchmarkUtil.factory.createEdgeVariable();
      final Procedure1<EdgeVariable> _function_16 = (EdgeVariable it) -> {
        it.setName("_e3");
        EList<EdgeLabel> _edgeLabels = it.getEdgeLabels();
        _edgeLabels.add(targetLabel);
        it.setDontCare(true);
        it.setContainer(switchSet);
      };
      final EdgeVariable _e3 = ObjectExtensions.<EdgeVariable>operator_doubleArrow(_createEdgeVariable_2, _function_16);
      GetVerticesOperator _createGetVerticesOperator = TrainBenchmarkUtil.factory.createGetVerticesOperator();
      final Procedure1<GetVerticesOperator> _function_17 = (GetVerticesOperator it) -> {
        it.setVertexVariable(semaphore);
      };
      final GetVerticesOperator getVertices = ObjectExtensions.<GetVerticesOperator>operator_doubleArrow(_createGetVerticesOperator, _function_17);
      ExpandOperator _createExpandOperator = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_18 = (ExpandOperator it) -> {
        it.setInput(getVertices);
        it.setDirection(Direction.IN);
        it.setSourceVertexVariable(semaphore);
        it.setTargetVertexVariable(route);
        it.setEdgeVariable(_e1);
      };
      final ExpandOperator expand1 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator, _function_18);
      ExpandOperator _createExpandOperator_1 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_19 = (ExpandOperator it) -> {
        it.setInput(expand1);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(route);
        it.setTargetVertexVariable(swP);
        it.setEdgeVariable(_e2);
      };
      final ExpandOperator expand2 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_1, _function_19);
      ExpandOperator _createExpandOperator_2 = TrainBenchmarkUtil.factory.createExpandOperator();
      final Procedure1<ExpandOperator> _function_20 = (ExpandOperator it) -> {
        it.setInput(expand2);
        it.setDirection(Direction.OUT);
        it.setSourceVertexVariable(swP);
        it.setTargetVertexVariable(sw);
        it.setEdgeVariable(_e3);
      };
      final ExpandOperator expand3 = ObjectExtensions.<ExpandOperator>operator_doubleArrow(_createExpandOperator_2, _function_20);
      AllDifferentOperator _createAllDifferentOperator = TrainBenchmarkUtil.factory.createAllDifferentOperator();
      final Procedure1<AllDifferentOperator> _function_21 = (AllDifferentOperator it) -> {
        it.setInput(expand3);
        EList<EdgeVariable> _edgeVariables = it.getEdgeVariables();
        List<EdgeVariable> _asList = Arrays.<EdgeVariable>asList(_e1, _e2, _e3);
        _edgeVariables.addAll(_asList);
      };
      final AllDifferentOperator allDifferent = ObjectExtensions.<AllDifferentOperator>operator_doubleArrow(_createAllDifferentOperator, _function_21);
      StringLiteral _createStringLiteral = TrainBenchmarkUtil.factory.createStringLiteral();
      final Procedure1<StringLiteral> _function_22 = (StringLiteral it) -> {
        it.setValue("GO");
      };
      final StringLiteral stringLiteralGO = ObjectExtensions.<StringLiteral>operator_doubleArrow(_createStringLiteral, _function_22);
      ArithmeticComparisonExpression _createArithmeticComparisonExpression = TrainBenchmarkUtil.factory.createArithmeticComparisonExpression();
      final Procedure1<ArithmeticComparisonExpression> _function_23 = (ArithmeticComparisonExpression it) -> {
        it.setLeftOperand(signal);
        it.setRightOperand(stringLiteralGO);
        it.setOperator(ArithmeticComparisonOperator.EQUAL_TO);
      };
      final ArithmeticComparisonExpression condition1 = ObjectExtensions.<ArithmeticComparisonExpression>operator_doubleArrow(_createArithmeticComparisonExpression, _function_23);
      SelectionOperator _createSelectionOperator = TrainBenchmarkUtil.factory.createSelectionOperator();
      final Procedure1<SelectionOperator> _function_24 = (SelectionOperator it) -> {
        it.setInput(allDifferent);
        it.setConditionString("semaphore.signal = \'GO\'");
        it.setCondition(condition1);
      };
      final SelectionOperator filter1 = ObjectExtensions.<SelectionOperator>operator_doubleArrow(_createSelectionOperator, _function_24);
      ArithmeticComparisonExpression _createArithmeticComparisonExpression_1 = TrainBenchmarkUtil.factory.createArithmeticComparisonExpression();
      final Procedure1<ArithmeticComparisonExpression> _function_25 = (ArithmeticComparisonExpression it) -> {
        it.setLeftOperand(currentPosition);
        it.setRightOperand(position);
        it.setOperator(ArithmeticComparisonOperator.NOT_EQUAL_TO);
      };
      final ArithmeticComparisonExpression condition2 = ObjectExtensions.<ArithmeticComparisonExpression>operator_doubleArrow(_createArithmeticComparisonExpression_1, _function_25);
      SelectionOperator _createSelectionOperator_1 = TrainBenchmarkUtil.factory.createSelectionOperator();
      final Procedure1<SelectionOperator> _function_26 = (SelectionOperator it) -> {
        it.setInput(filter1);
        it.setConditionString("sw.currentPosition != swP.position");
        it.setCondition(condition2);
      };
      final SelectionOperator filter2 = ObjectExtensions.<SelectionOperator>operator_doubleArrow(_createSelectionOperator_1, _function_26);
      ProjectionOperator _createProjectionOperator = TrainBenchmarkUtil.factory.createProjectionOperator();
      final Procedure1<ProjectionOperator> _function_27 = (ProjectionOperator it) -> {
        it.setInput(filter2);
        EList<Variable> _variables = it.getVariables();
        List<Variable> _asList = Arrays.<Variable>asList(semaphore, route, swP, sw, currentPosition, position);
        _variables.addAll(_asList);
      };
      final ProjectionOperator projection = ObjectExtensions.<ProjectionOperator>operator_doubleArrow(_createProjectionOperator, _function_27);
      DuplicateEliminationOperator _createDuplicateEliminationOperator = TrainBenchmarkUtil.factory.createDuplicateEliminationOperator();
      final Procedure1<DuplicateEliminationOperator> _function_28 = (DuplicateEliminationOperator it) -> {
        it.setInput(projection);
      };
      final DuplicateEliminationOperator de = ObjectExtensions.<DuplicateEliminationOperator>operator_doubleArrow(_createDuplicateEliminationOperator, _function_28);
      ProductionOperator _createProductionOperator = TrainBenchmarkUtil.factory.createProductionOperator();
      final Procedure1<ProductionOperator> _function_29 = (ProductionOperator it) -> {
        it.setInput(de);
      };
      final ProductionOperator production = ObjectExtensions.<ProductionOperator>operator_doubleArrow(_createProductionOperator, _function_29);
      switchSet.setRootExpression(production);
      _xblockexpression = switchSet;
    }
    return _xblockexpression;
  }
}
