/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.web.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import in.sourceshift.genericmodules.securityutils.BaseEncoder;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadProcessor {
    private static final Logger log = LoggerFactory.getLogger(PayloadProcessor.class);
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    ObjectMapper mappernew = new ObjectMapper();
    ObjectNode keyvalue = this.mappernew.createObjectNode();
    private final Set<String> predefinepayload = new HashSet<String>(Arrays.asList("iss", "sub", "aud", "exp", "nbf", "iat", "jti"));

    public PayloadProcessor setProperty(String key, String value) {
        if (this.predefinepayload.contains(key)) {
            log.warn("Use inbuild method instade of raw headers");
        }
        this.keyvalue.put(key, value);
        return this;
    }

    public String getProperty(String key) {
        if (this.predefinepayload.contains(key)) {
            log.warn("Use inbuild method instade of raw headers");
        }
        return this.keyvalue.get(key).asText();
    }

    public PayloadProcessor setIssuer(String issuer) {
        this.keyvalue.put("iss", issuer);
        return this;
    }

    public PayloadProcessor setSubject(String subject) {
        this.keyvalue.put("sub", subject);
        return this;
    }

    public PayloadProcessor setAudience(String audience) {
        this.keyvalue.put("aud", audience);
        return this;
    }

    public PayloadProcessor setExpirationTime(Date expirationTime) throws SecurityUtilsException {
        if (this.getIssuedat() == null) {
            this.setIssuedat(new Date());
        }
        this.keyvalue.put("exp", this.simpleDateFormat.format(expirationTime));
        return this;
    }

    public PayloadProcessor setExpirationTime(int validitycalunit, int validity) throws SecurityUtilsException {
        if (this.getIssuedat() == null) {
            this.setIssuedat(new Date());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getIssuedat());
        cal.add(validitycalunit, validity);
        this.setExpirationTime(cal.getTime());
        return this;
    }

    public PayloadProcessor setNotBefore(Date notBefore) throws SecurityUtilsException {
        if (this.getIssuedat() == null) {
            this.setIssuedat(new Date());
        }
        this.keyvalue.put("nbf", this.simpleDateFormat.format(notBefore));
        return this;
    }

    public PayloadProcessor setNotBefore(int validitycalunit, int validity) throws SecurityUtilsException {
        if (this.getIssuedat() == null) {
            this.setIssuedat(new Date());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getIssuedat());
        cal.add(validitycalunit, validity);
        this.setNotBefore(cal.getTime());
        return this;
    }

    public PayloadProcessor setIssuedat(Date issuedat) {
        this.keyvalue.put("iat", this.simpleDateFormat.format(issuedat));
        return this;
    }

    public PayloadProcessor setJWTID(String jWTID) {
        this.keyvalue.put("jti", jWTID);
        return this;
    }

    public String getIssuer() {
        return this.keyvalue.get("iss").asText();
    }

    public String getSubject() {
        return this.keyvalue.get("sub").asText();
    }

    public String getAudience() {
        return this.keyvalue.get("aud").asText();
    }

    public Date getExpirationTime() throws SecurityUtilsException {
        try {
            if (this.keyvalue.path("exp").isMissingNode()) {
                return null;
            }
            return this.simpleDateFormat.parse(this.keyvalue.get("exp").asText());
        }
        catch (ParseException e) {
            throw new SecurityUtilsException("Unable to parse ExpirationTime form JWT Payload", e);
        }
    }

    public Date getNotBefore() throws SecurityUtilsException {
        try {
            if (this.keyvalue.path("nbf").isMissingNode()) {
                return null;
            }
            return this.simpleDateFormat.parse(this.keyvalue.get("nbf").asText());
        }
        catch (ParseException e) {
            throw new SecurityUtilsException("Unable to parse NotBefore form JWT Payload", e);
        }
    }

    public Date getIssuedat() throws SecurityUtilsException {
        try {
            if (this.keyvalue.path("iat").isMissingNode()) {
                return null;
            }
            return this.simpleDateFormat.parse(this.keyvalue.get("iat").asText());
        }
        catch (ParseException e) {
            throw new SecurityUtilsException("Unable to parse Issuedat form JWT Payload", e);
        }
    }

    public String getJWTID() {
        return this.keyvalue.get("jti").asText();
    }

    public String getbase64urlencodedJson() throws SecurityUtilsException {
        String json = this.keyvalue.toString();
        String base64json = BaseEncoder.encodeBase64toString(json);
        String b64url = URLEncoder.encode(base64json, StandardCharsets.UTF_8);
        return b64url;
    }

    public PayloadProcessor decodefrombase64urlencodedJson(String base64urlencodedJson) throws SecurityUtilsException {
        String base64json = URLDecoder.decode(base64urlencodedJson, StandardCharsets.UTF_8);
        String json = BaseEncoder.decodeBase64toString(base64json);
        try {
            this.keyvalue = (ObjectNode)this.mappernew.readTree(json);
        }
        catch (IOException e) {
            throw new SecurityUtilsException("Unable to decode JWTPayload Json", e);
        }
        return this;
    }

    public PayloadProcessor decodefromJson(String payloadJson) throws SecurityUtilsException {
        try {
            this.keyvalue = (ObjectNode)this.mappernew.readTree(payloadJson);
        }
        catch (IOException e) {
            throw new SecurityUtilsException("Unable to decode JWTPayload Json", e);
        }
        return this;
    }

    public String toString() {
        return this.getPayloadJson();
    }

    public String getPayloadJson() {
        return this.keyvalue.toString();
    }
}

