/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.web.jwt;

import in.sourceshift.genericmodules.securityutils.HashwithSecret;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.HashType;
import in.sourceshift.genericmodules.securityutils.web.jwt.HeaderProcessor;
import in.sourceshift.genericmodules.securityutils.web.jwt.JWTBuilder;
import in.sourceshift.genericmodules.securityutils.web.jwt.JWTDecoder;
import in.sourceshift.genericmodules.securityutils.web.jwt.JWTHashType;
import in.sourceshift.genericmodules.securityutils.web.jwt.PayloadProcessor;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public class JWT
implements JWTBuilder,
JWTDecoder {
    private HeaderProcessor headerProcessor;
    private PayloadProcessor payloadProcessor;
    private String headerJson;
    private String base64urlencodedJsonHeader;
    private String payloadJson;
    private String base64urlencodedJsonpayload;
    private String signaturebase64url;
    private String secret;
    private String token;

    private JWT() {
    }

    private JWT(String token) throws SecurityUtilsException {
        this.token = token;
        String[] jwtsplit = token.split("\\.");
        this.base64urlencodedJsonHeader = jwtsplit[0];
        this.base64urlencodedJsonpayload = jwtsplit[1];
        this.signaturebase64url = jwtsplit[2];
        this.headerProcessor = new HeaderProcessor().decodefrombase64urlencodedJson(this.base64urlencodedJsonHeader);
        this.payloadProcessor = new PayloadProcessor().decodefrombase64urlencodedJson(this.base64urlencodedJsonpayload);
        this.headerJson = this.headerProcessor.getHeaderJson();
        this.payloadJson = this.payloadProcessor.getPayloadJson();
    }

    @Override
    public HeaderProcessor getHeaderProcessor() {
        return this.headerProcessor;
    }

    @Override
    public PayloadProcessor getPayloadProcessor() {
        return this.payloadProcessor;
    }

    public static JWTBuilder getBuilder() {
        return new JWT();
    }

    public static JWTDecoder getDecoder(String token) throws SecurityUtilsException {
        return new JWT(token);
    }

    private void build() throws SecurityUtilsException {
        String headandpay = this.base64urlencodedJsonHeader + "." + this.base64urlencodedJsonpayload;
        if (!this.headerProcessor.getAlgorithm().equals((Object)JWTHashType.HS256)) {
            throw new SecurityUtilsException("HashType not supported");
        }
        String tempsign = HashwithSecret.setData(headandpay).setSecret(this.secret).setHashtype(HashType.HMAC_SHA256).create();
        this.signaturebase64url = URLEncoder.encode(tempsign, StandardCharsets.UTF_8);
        this.token = headandpay + "." + this.signaturebase64url;
    }

    @Override
    public boolean validate() throws SecurityUtilsException {
        return this.verifyHash() && this.verifyexptime();
    }

    private boolean verifyHash() throws SecurityUtilsException {
        String headerandpayloadtoken = this.base64urlencodedJsonHeader + "." + this.base64urlencodedJsonpayload;
        String oldhash = URLDecoder.decode(this.signaturebase64url, StandardCharsets.UTF_8);
        if (!this.headerProcessor.getAlgorithm().equals((Object)JWTHashType.HS256)) {
            throw new SecurityUtilsException("HashType not supported");
        }
        HashType hmac = HashType.HMAC_SHA256;
        if (!HashwithSecret.setData(headerandpayloadtoken).setHashtype(hmac).setSecret(this.secret).verify(oldhash)) {
            throw new SecurityUtilsException("Regenerated Hash integrity varification failed");
        }
        return true;
    }

    private boolean verifyexptime() throws SecurityUtilsException {
        Date Current = new Date();
        if (this.payloadProcessor.getIssuedat() != null && this.payloadProcessor.getNotBefore() != null && (this.payloadProcessor.getIssuedat().after(Current) || this.payloadProcessor.getIssuedat().after(this.payloadProcessor.getNotBefore()))) {
            throw new SecurityUtilsException("JWT integrity validation failed, JWT ID: " + this.payloadProcessor.getJWTID());
        }
        if (this.payloadProcessor.getExpirationTime() != null && this.payloadProcessor.getExpirationTime().before(Current)) {
            throw new SecurityUtilsException("JWT expired, JWT ID: " + this.payloadProcessor.getJWTID());
        }
        if (this.payloadProcessor.getNotBefore() != null && this.payloadProcessor.getNotBefore().after(Current)) {
            throw new SecurityUtilsException("JWT is not yet available for use, JWT ID: " + this.payloadProcessor.getJWTID());
        }
        return true;
    }

    @Override
    public String quickRebuild(String key, String value) throws SecurityUtilsException {
        this.payloadProcessor.setProperty(key, value);
        JWTBuilder jwt = JWT.getBuilder().setHeaderJson(this.getHeaderJson()).setPayloadJson(this.payloadProcessor.getPayloadJson());
        jwt.setSecret(this.secret);
        return jwt.getToken();
    }

    @Override
    public String getHeaderJson() {
        return this.headerJson;
    }

    @Override
    public String getPayloadJson() {
        return this.payloadJson;
    }

    @Override
    public JWTBuilder setHeaderJson(String headerJson) throws SecurityUtilsException {
        this.headerProcessor = new HeaderProcessor().decodefromJson(headerJson);
        this.base64urlencodedJsonHeader = this.headerProcessor.getbase64urlencodedJson();
        this.headerJson = headerJson;
        return this;
    }

    @Override
    public JWTBuilder setPayloadJson(String payloadJson) throws SecurityUtilsException {
        this.payloadProcessor = new PayloadProcessor().decodefromJson(payloadJson);
        this.base64urlencodedJsonpayload = this.payloadProcessor.getbase64urlencodedJson();
        this.payloadJson = payloadJson;
        return this;
    }

    @Override
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Override
    public String getToken() throws SecurityUtilsException {
        this.build();
        return this.token;
    }
}

