/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.web.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import in.sourceshift.genericmodules.securityutils.BaseEncoder;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import in.sourceshift.genericmodules.securityutils.web.jwt.JWTHashType;
import in.sourceshift.genericmodules.securityutils.web.jwt.TokenType;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderProcessor {
    private static final Logger log = LoggerFactory.getLogger(HeaderProcessor.class);
    ObjectMapper mappernew = new ObjectMapper();
    ObjectNode keyvalue = this.mappernew.createObjectNode();
    private final Set<String> predefineheader = new HashSet<String>(Arrays.asList("alg", "typ"));

    @Deprecated
    public HeaderProcessor setProperty(String key, String value) {
        if (this.predefineheader.contains(key)) {
            log.warn("Use inbuild method instade of raw headers");
        }
        this.keyvalue.put(key, value);
        return this;
    }

    @Deprecated
    public String getProperty(String key) {
        if (this.predefineheader.contains(key)) {
            log.warn("Use inbuild method instade of raw headers");
        }
        return this.keyvalue.get(key).asText();
    }

    public HeaderProcessor setTokentype(TokenType tokentype) {
        this.keyvalue.put("typ", String.valueOf((Object)tokentype));
        return this;
    }

    public TokenType getTokentype() {
        return TokenType.valueOf(this.keyvalue.get("typ").asText());
    }

    public HeaderProcessor setAlgorithm(JWTHashType algorithm) {
        this.keyvalue.put("alg", String.valueOf((Object)algorithm));
        return this;
    }

    public JWTHashType getAlgorithm() {
        return JWTHashType.valueOf(this.keyvalue.get("alg").asText());
    }

    public String getbase64urlencodedJson() throws SecurityUtilsException {
        String json = this.keyvalue.toString();
        String base64json = BaseEncoder.encodeBase64toString(json);
        String b64url = URLEncoder.encode(base64json, StandardCharsets.UTF_8);
        return b64url;
    }

    public HeaderProcessor decodefrombase64urlencodedJson(String base64urlencodedJson) throws SecurityUtilsException {
        String base64json = URLDecoder.decode(base64urlencodedJson, StandardCharsets.UTF_8);
        String json = BaseEncoder.decodeBase64toString(base64json);
        try {
            this.keyvalue = (ObjectNode)this.mappernew.readTree(json);
        }
        catch (IOException e) {
            throw new SecurityUtilsException("Unable to decode JWTPayload Json", e);
        }
        return this;
    }

    public HeaderProcessor decodefromJson(String headerJson) throws SecurityUtilsException {
        try {
            this.keyvalue = (ObjectNode)this.mappernew.readTree(headerJson);
        }
        catch (IOException e) {
            throw new SecurityUtilsException("Unable to decode JWTPayload Json", e);
        }
        return this;
    }

    public String toString() {
        return this.getHeaderJson();
    }

    public String getHeaderJson() {
        return this.keyvalue.toString();
    }
}

