/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.vaultadapter.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import in.sourceshift.genericmodules.httputils.generic.HTTPExecuter;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.HttpResponse;

public class VaultHTTPExecutor {
    private final String vaultAPIEndPoint;
    private Map<String, String> headers;

    public VaultHTTPExecutor(String vaultEndPoint) {
        this.vaultAPIEndPoint = vaultEndPoint + "/v1";
        this.headers = new HashMap<String, String>();
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Accept", "application/json");
    }

    public void addCommonHeader(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void addCommonHeader(String k, String v) {
        this.headers.put(k, v);
    }

    public JsonNode doHTTP(String resourceURI, String method, Map<String, String> headers, ObjectNode requestBody) throws VaultAdapterException {
        ObjectNode resJsonNode;
        Map<String, String> tempheader;
        String url = this.vaultAPIEndPoint + resourceURI;
        if (MapUtils.isNotEmpty(headers)) {
            tempheader = new HashMap<String, String>();
            tempheader.putAll(this.headers);
            tempheader.putAll(headers);
        } else {
            tempheader = this.headers;
        }
        try {
            HttpResponse response = null;
            try {
                response = HTTPExecuter.doHTTP((String)url, (String)method, tempheader, null, (Object)requestBody);
            }
            catch (HTTPUtilsException e) {
                throw new VaultAdapterException("Unable to execute HTTP request", e);
            }
            resJsonNode = response.getBody() != null && ((byte[])response.getBody()).length != 0 ? (ObjectNode)MapUtils.getMapperInstance().readTree(new String((byte[])response.getBody())) : MapUtils.getMapperInstance().createObjectNode();
            resJsonNode.put("VaultHTTPExecutorStatusCode", response.getStatus());
        }
        catch (Exception e) {
            throw new VaultAdapterException("Unable to make HTTP call", e);
        }
        int status = resJsonNode.at("/VaultHTTPExecutorStatusCode").asInt();
        if (status >= 400 && status != 404) {
            throw new VaultAdapterException("Error from vault service : " + resJsonNode.toString());
        }
        return resJsonNode;
    }

    public JsonNode doGET(String resourceURI) throws VaultAdapterException {
        return this.doGET(resourceURI, null);
    }

    public JsonNode doGET(String resourceURI, Map<String, String> headers) throws VaultAdapterException {
        return this.doHTTP(resourceURI, "GET", headers, null);
    }

    public JsonNode doPOST(String resourceURI, Map<String, String> headers, ObjectNode requestBody) throws VaultAdapterException {
        return this.doHTTP(resourceURI, "POST", headers, requestBody);
    }

    public JsonNode doPOST(String resourceURI, ObjectNode requestBody) throws VaultAdapterException {
        return this.doPOST(resourceURI, null, requestBody);
    }

    public JsonNode doPOST(String resourceURI) throws VaultAdapterException {
        return this.doPOST(resourceURI, null, null);
    }

    public JsonNode doLIST(String resourceURI) throws VaultAdapterException {
        return this.doHTTP(resourceURI, "LIST", null, null);
    }

    public JsonNode doDelete(String resourceURI) throws VaultAdapterException {
        return this.doHTTP(resourceURI, "DELETE", null, null);
    }

    public void setNamespace(String namespace) {
        if (MapUtils.isNotEmpty((CharSequence)namespace)) {
            this.headers.put("X-Vault-Namespace", namespace);
        }
    }

    public void setxVaultToken(String xVaultToken) {
        if (MapUtils.isNotEmpty((CharSequence)xVaultToken)) {
            this.headers.put("X-Vault-Token", xVaultToken);
        }
    }

    public String getxVaultToken() {
        return this.headers.get("X-Vault-Token");
    }
}

