/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.vaultadapter.ops;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.KV;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KVv2
implements KV {
    private final VaultHTTPExecutor httpExecutor;
    private final String secretEngineName;

    public KVv2(VaultHTTPExecutor httpExecutor, String secretEngineName) {
        this.httpExecutor = httpExecutor;
        this.secretEngineName = MapUtils.removeEndStart((String)secretEngineName, (String)"/");
    }

    @Override
    public JsonNode getKeyValues(String pathOfSecret) throws VaultAdapterException {
        pathOfSecret = MapUtils.removeEndStart((String)pathOfSecret, (String)"/");
        String keyvalueURI = "/" + this.secretEngineName + "/data/" + pathOfSecret;
        JsonNode response = this.httpExecutor.doGET(keyvalueURI);
        try {
            JsonNode responseData = response.at("/data/data");
            if (responseData.isEmpty()) {
                return null;
            }
            return responseData;
        }
        catch (RuntimeException e) {
            throw new VaultAdapterException(String.format("Unable to Keys Error : [Status=%s, body=%s ]", response.get("VaultHTTPExecutorStatusCode"), response.toPrettyString()));
        }
    }

    @Override
    public JsonNode addorupdateKeyValues(String pathOfSecret, Map<String, String> newKeyValues) throws VaultAdapterException {
        ObjectNode newKeyValuesObjectNode = (ObjectNode)MapUtils.mapAsJsonNode(newKeyValues);
        return this.addorupdateKeyValues(pathOfSecret, newKeyValuesObjectNode);
    }

    @Override
    public JsonNode addorupdateKeyValues(String pathOfSecret, ObjectNode newKeyValues) throws VaultAdapterException {
        JsonNode existingKeyValues = this.getKeyValues(pathOfSecret);
        ObjectNode updatedKeyValues = MapUtils.mergeJson((JsonNode)existingKeyValues, (ObjectNode)newKeyValues);
        return this.postKeyValues(pathOfSecret, updatedKeyValues);
    }

    @Override
    public JsonNode addorupdateKeyValues(String pathOfSecret, String k, String v) throws VaultAdapterException {
        HashMap<String, String> newKeyValue = new HashMap<String, String>();
        newKeyValue.put(k, v);
        return this.addorupdateKeyValues(pathOfSecret, newKeyValue);
    }

    @Override
    public ArrayNode listKeys(String pathOfSecret) throws VaultAdapterException {
        pathOfSecret = MapUtils.removeEndStart((String)pathOfSecret, (String)"/");
        String keyvalueURI = "/" + this.secretEngineName + "/metadata/" + pathOfSecret;
        return (ArrayNode)this.httpExecutor.doLIST(keyvalueURI).get("data").get("keys");
    }

    @Override
    public JsonNode postKeyValues(String pathOfSecret, ObjectNode keyValues) throws VaultAdapterException {
        pathOfSecret = MapUtils.removeEndStart((String)pathOfSecret, (String)"/");
        ObjectNode newKeyValuedatanode = MapUtils.getMapperInstance().createObjectNode();
        newKeyValuedatanode.set("data", (JsonNode)keyValues);
        String keyvalueURI = "/" + this.secretEngineName + "/data/" + pathOfSecret;
        return this.httpExecutor.doPOST(keyvalueURI, newKeyValuedatanode);
    }

    @Override
    public JsonNode removeKeyValues(String pathOfSecret, Set<String> keystoberemoved) throws VaultAdapterException {
        JsonNode existingKeyValues = this.getKeyValues(pathOfSecret);
        if (existingKeyValues != null) {
            ObjectNode existingObjectNode = (ObjectNode)existingKeyValues;
            existingObjectNode.remove(keystoberemoved);
            return this.postKeyValues(pathOfSecret, existingObjectNode);
        }
        return null;
    }

    @Override
    public JsonNode removeKeyValues(String pathOfSecret, String keystoberemoved) throws VaultAdapterException {
        HashSet<String> remove = new HashSet<String>();
        remove.add(keystoberemoved);
        return this.removeKeyValues(pathOfSecret, remove);
    }

    @Override
    public void deleteSecretPath(String pathOfSecret) throws VaultAdapterException {
        pathOfSecret = MapUtils.removeEndStart((String)pathOfSecret, (String)"/");
        this.httpExecutor.doDelete("/metadata/" + this.secretEngineName + "/" + pathOfSecret);
    }
}

