/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.vaultadapter.auth;

import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.AppRoleImplementation;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.AuthImplementation;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.GitHubImplementation;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.LDAPImplementation;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.UserpassImplementation;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;
import java.util.Map;

public class VaultAuth {
    private AuthImplementation authimp;

    public VaultAuth(VaultHTTPExecutor httpExecutor, VaultAuthType type, Map<String, String> userPrivate) throws VaultAdapterException {
        String appsecretID = "appsecretID";
        String approleID = "approleID";
        String githubPAT = "githubPAT";
        String password = "password";
        String username = "username";
        String customPath = "customPath";
        switch (type) {
            case LDAP: {
                this.authimp = new LDAPImplementation(httpExecutor, userPrivate.get(username), userPrivate.get(password));
                break;
            }
            case GITHUB: {
                this.authimp = new GitHubImplementation(httpExecutor, userPrivate.get(customPath), userPrivate.get(githubPAT));
                break;
            }
            case USERPASS: {
                this.authimp = new UserpassImplementation(httpExecutor, userPrivate.get(username), userPrivate.get(password));
                break;
            }
            case APPROLE: {
                this.authimp = new AppRoleImplementation(httpExecutor, userPrivate.get(approleID), userPrivate.get(appsecretID));
                break;
            }
            default: {
                throw new VaultAdapterException("VaultAuthType not supported");
            }
        }
    }

    public String getXVaultToken() throws VaultAdapterException {
        try {
            this.authimp.buildAuthendpoint();
            this.authimp.buildBody();
            return this.authimp.getXVaultToken();
        }
        catch (RuntimeException e) {
            throw new VaultAdapterException("Unable to obtain the Vault Authentication token / xVaultToken", e);
        }
    }

    public static enum VaultAuthType {
        USERPASS,
        GITHUB,
        LDAP,
        APPROLE;

    }
}

