/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.vaultadapter.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.AuthImplementation;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class UserpassImplementation
implements AuthImplementation {
    private final String username;
    private final String password;
    private VaultHTTPExecutor httpExecutor;
    private String vaultAuthenticationEndpoint;
    private ObjectNode body;

    public UserpassImplementation(VaultHTTPExecutor httpExecutor, String username, String password) {
        this.username = username;
        this.password = password;
        this.httpExecutor = httpExecutor;
    }

    @Override
    public String getXVaultToken() throws VaultAdapterException {
        JsonNode response = this.httpExecutor.doPOST(this.vaultAuthenticationEndpoint, null, this.body);
        try {
            return response.get("auth").get("client_token").asText();
        }
        catch (RuntimeException e) {
            throw new VaultAdapterException(String.format("Unable to get Vault Authentication [Status=%s, body=%s ]", response.get("VaultHTTPExecutorStatusCode"), response.toPrettyString()));
        }
    }

    @Override
    public void buildAuthendpoint() {
        this.vaultAuthenticationEndpoint = "/auth/userpass/login/" + this.username;
    }

    @Override
    public void buildBody() {
        this.body = MapUtils.getMapperInstance().createObjectNode();
        this.body.put("password", this.password);
    }
}

