/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.vaultadapter.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.AuthImplementation;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class GitHubImplementation
implements AuthImplementation {
    private ObjectNode body;
    private final String githubPAT;
    private VaultHTTPExecutor httpExecutor;
    private final String customPath;
    private String vaultAuthenticationEndpoint;

    public GitHubImplementation(VaultHTTPExecutor httpExecutor, String customPath, String githubPAT) {
        this.githubPAT = githubPAT;
        this.httpExecutor = httpExecutor;
        this.customPath = customPath;
    }

    @Override
    public String getXVaultToken() throws VaultAdapterException {
        JsonNode response = this.httpExecutor.doPOST(this.vaultAuthenticationEndpoint, null, this.body);
        try {
            return response.get("auth").get("client_token").asText();
        }
        catch (RuntimeException e) {
            throw new VaultAdapterException(String.format("Unable to get Vault Authentication [Status=%s, body=%s ]", response.get("VaultHTTPExecutorStatusCode"), response.toPrettyString()));
        }
    }

    @Override
    public void buildAuthendpoint() {
        this.vaultAuthenticationEndpoint = MapUtils.isNotEmpty((CharSequence)this.customPath) ? "/auth/github_" + this.customPath + "/login" : "/auth/github/login";
    }

    @Override
    public void buildBody() {
        this.body = MapUtils.getMapperInstance().createObjectNode();
        this.body.put("token", this.githubPAT);
    }
}

