/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.vaultadapter.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.AuthImplementation;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class AppRoleImplementation
implements AuthImplementation {
    private final String approleID;
    private final String appsecretID;
    private ObjectNode body;
    private String vaultAuthenticationEndpoint;
    private VaultHTTPExecutor httpExecutor;

    public AppRoleImplementation(VaultHTTPExecutor httpExecutor, String approleID, String appsecretID) {
        this.approleID = approleID;
        this.appsecretID = appsecretID;
        this.httpExecutor = httpExecutor;
    }

    @Override
    public String getXVaultToken() throws VaultAdapterException {
        JsonNode response = this.httpExecutor.doPOST(this.vaultAuthenticationEndpoint, null, this.body);
        try {
            return response.get("auth").get("client_token").asText();
        }
        catch (RuntimeException e) {
            throw new VaultAdapterException(String.format("Unable to get Vault Authentication [Status=%s, body=%s ]", response.get("VaultHTTPExecutorStatusCode"), response.toPrettyString()));
        }
    }

    @Override
    public void buildAuthendpoint() {
        this.vaultAuthenticationEndpoint = "/auth/approle/login";
    }

    @Override
    public void buildBody() {
        this.body = MapUtils.getMapperInstance().createObjectNode();
        this.body.put("role_id", this.approleID);
        this.body.put("secret_id", this.appsecretID);
    }
}

