/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.vaultadapter;

import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.VaultAPIAdapter;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.VaultAuth;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class VaultConfig {
    private final String vaultEndPoint;
    private String xVaultToken = null;
    private VaultAuth.VaultAuthType authenticationType;
    private Map<String, String> userPrivate = new HashMap<String, String>();
    private String namespace;
    private VaultHTTPExecutor httpExecutor;

    public VaultConfig(String vaultEndPoint) {
        this.vaultEndPoint = StringUtils.removeEnd((String)vaultEndPoint, (String)"/");
    }

    public VaultConfig setCustomPath(String customPath) {
        this.userPrivate.put("customPath", customPath);
        return this;
    }

    public VaultConfig setGithubPAT(String githubPAT) {
        this.userPrivate.put("githubPAT", githubPAT);
        return this;
    }

    public VaultConfig setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public VaultConfig setxVaultToken(String xVaultToken) {
        this.xVaultToken = xVaultToken;
        return this;
    }

    public VaultConfig setUsername(String username) {
        this.userPrivate.put("username", username);
        return this;
    }

    public VaultConfig setPassword(String password) {
        this.userPrivate.put("password", password);
        return this;
    }

    public VaultConfig setApproleID(String approleID) {
        this.userPrivate.put("approleID", approleID);
        return this;
    }

    public VaultConfig setAppsecretID(String appsecretID) {
        this.userPrivate.put("appsecretID", appsecretID);
        return this;
    }

    public static VaultConfig init(String vaultEndPoint) {
        return new VaultConfig(vaultEndPoint);
    }

    private void buildHttpExecutor() {
        if (this.httpExecutor == null) {
            this.httpExecutor = new VaultHTTPExecutor(this.vaultEndPoint);
        }
        if (MapUtils.isNotEmpty((CharSequence)this.xVaultToken)) {
            this.httpExecutor.setxVaultToken(this.xVaultToken);
        }
        if (MapUtils.isNotEmpty((CharSequence)this.namespace)) {
            this.httpExecutor.setNamespace(this.namespace);
        }
    }

    public VaultConfig setAuthenticationType(VaultAuth.VaultAuthType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public VaultAPIAdapter build() throws VaultAdapterException {
        this.buildHttpExecutor();
        if (this.xVaultToken == null) {
            this.xVaultToken = new VaultAuth(this.httpExecutor, this.authenticationType, this.userPrivate).getXVaultToken();
            this.buildHttpExecutor();
        }
        return new VaultAPIAdapter(this.httpExecutor);
    }
}

