/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.vaultadapter;

import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.AppRole;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.KV;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.KVv1;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.KVv2;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.Token;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;
import java.io.Closeable;
import java.io.IOException;

public class VaultAPIAdapter
implements Closeable {
    private VaultHTTPExecutor httpExecutor;

    public VaultAPIAdapter(VaultHTTPExecutor httpExecutor) {
        this.httpExecutor = httpExecutor;
    }

    public KV getKVvinstance(String secretEngineName) throws VaultAdapterException {
        return this.getKVvinstance(secretEngineName, 1);
    }

    public KV getKVvinstance(String secretEngineName, int kvversion) throws VaultAdapterException {
        switch (kvversion) {
            case 1: {
                return new KVv1(this.httpExecutor, secretEngineName);
            }
            case 2: {
                return new KVv2(this.httpExecutor, secretEngineName);
            }
        }
        throw new VaultAdapterException("Key Value engine version not supported");
    }

    public Token getToken() throws VaultAdapterException {
        return new Token(this.httpExecutor);
    }

    public AppRole getAppRole() {
        return new AppRole(this.httpExecutor);
    }

    @Override
    public void close() throws IOException {
        try {
            this.getToken().doSelfrevoke();
        }
        catch (VaultAdapterException e) {
            throw new IOException("Unable to revoke xVaultToken", e);
        }
    }
}

