/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.otp;

import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;

public class HmacOneTimePasswordGenerator {
    private final Mac mac;
    private final int passwordLength;
    private final byte[] buffer;
    private final int modDivisor;
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    public static final String HOTP_HMAC_ALGORITHM = "HmacSHA1";

    public HmacOneTimePasswordGenerator() throws SecurityUtilsException {
        this(6);
    }

    public HmacOneTimePasswordGenerator(int passwordLength) throws SecurityUtilsException {
        this(passwordLength, HOTP_HMAC_ALGORITHM);
    }

    public HmacOneTimePasswordGenerator(int passwordLength, String algorithm) throws SecurityUtilsException {
        try {
            this.mac = Mac.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityUtilsException(e);
        }
        switch (passwordLength) {
            case 6: {
                this.modDivisor = 1000000;
                break;
            }
            case 7: {
                this.modDivisor = 10000000;
                break;
            }
            case 8: {
                this.modDivisor = 100000000;
                break;
            }
            default: {
                throw new SecurityUtilsException("Password length must be between 6 and 8 digits.");
            }
        }
        this.passwordLength = passwordLength;
        this.buffer = new byte[this.mac.getMacLength()];
    }

    public synchronized int generateOneTimePassword(Key key, long counter) throws SecurityUtilsException {
        try {
            this.mac.init(key);
        }
        catch (InvalidKeyException e1) {
            throw new SecurityUtilsException(e1);
        }
        this.buffer[0] = (byte)((counter & 0xFF00000000000000L) >>> 56);
        this.buffer[1] = (byte)((counter & 0xFF000000000000L) >>> 48);
        this.buffer[2] = (byte)((counter & 0xFF0000000000L) >>> 40);
        this.buffer[3] = (byte)((counter & 0xFF00000000L) >>> 32);
        this.buffer[4] = (byte)((counter & 0xFF000000L) >>> 24);
        this.buffer[5] = (byte)((counter & 0xFF0000L) >>> 16);
        this.buffer[6] = (byte)((counter & 0xFF00L) >>> 8);
        this.buffer[7] = (byte)(counter & 0xFFL);
        this.mac.update(this.buffer, 0, 8);
        try {
            this.mac.doFinal(this.buffer, 0);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException(e);
        }
        int offset = this.buffer[this.buffer.length - 1] & 0xF;
        return ((this.buffer[offset] & 0x7F) << 24 | (this.buffer[offset + 1] & 0xFF) << 16 | (this.buffer[offset + 2] & 0xFF) << 8 | this.buffer[offset + 3] & 0xFF) % this.modDivisor;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

