/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.hashalgorithms;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2 {
    public final int DEFAULT_HASH_LENGTH = 18;
    public final int DEFAULT_SALT_LENGTH = 24;
    public final int DEFAULT_ITERATIONS = 64000;

    public byte[] create(char[] password, byte[] salt, String algorithm, int iterations, int hashSize) throws IllegalArgumentException {
        if (iterations < 1000) {
            iterations = 64000;
        }
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, hashSize * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
            return skf.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Hash algorithm not supported.", ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new IllegalArgumentException("Invalid key spec.", ex);
        }
    }
}

