/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.hashalgorithms;

import in.sourceshift.genericmodules.securityutils.BaseEncoder;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacSHA256 {
    public final int DEFAULT_SALT_LENGTH = 16;
    public final String HMAC_SHA256 = "HmacSHA256";

    public String create(String data, String key) throws SecurityUtilsException {
        Mac hMacSHA256;
        if (data == null) {
            throw new NullPointerException();
        }
        byte[] hmacKeyBytes = key.getBytes(StandardCharsets.UTF_8);
        try {
            hMacSHA256 = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityUtilsException(e);
        }
        SecretKeySpec secretKey = new SecretKeySpec(hmacKeyBytes, "HmacSHA256");
        try {
            hMacSHA256.init(secretKey);
        }
        catch (InvalidKeyException e) {
            throw new SecurityUtilsException(e);
        }
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] res = hMacSHA256.doFinal(dataBytes);
        return BaseEncoder.encodeBase64toString(res);
    }
}

