/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils.encryptionalgorithms;

import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.Decrypt;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.Encrypt;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES
implements Encrypt,
Decrypt {
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private byte[] iv;
    private AlgorithmParameterSpec paramSpec;
    private byte[] encryptedData;
    private byte[] decryptedData;
    private SecretKey secretKey;
    private byte[] encryptionkey;

    public AES() throws SecurityUtilsException {
        try {
            this.encryptCipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            this.decryptCipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new SecurityUtilsException(e);
        }
    }

    public void setKey() {
        this.paramSpec = new IvParameterSpec(this.iv);
        this.secretKey = new SecretKeySpec(this.encryptionkey, 0, this.encryptionkey.length, "AES");
    }

    @Override
    public void encrypt() throws SecurityUtilsException {
        this.setKey();
        try {
            this.encryptCipher.init(1, (Key)this.secretKey, this.paramSpec);
            this.encryptedData = this.encryptCipher.doFinal(this.decryptedData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new SecurityUtilsException(e);
        }
    }

    @Override
    public void decrypt() throws SecurityUtilsException {
        this.setKey();
        try {
            this.decryptCipher.init(2, (Key)this.secretKey, this.paramSpec);
            this.decryptedData = this.decryptCipher.doFinal(this.encryptedData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new SecurityUtilsException(e);
        }
    }

    @Override
    public Cipher getEncryptCipher() {
        return this.encryptCipher;
    }

    public void setEncryptCipher(Cipher encryptCipher) {
        this.encryptCipher = encryptCipher;
    }

    @Override
    public Cipher getDecryptCipher() {
        return this.decryptCipher;
    }

    public void setDecryptCipher(Cipher decryptCipher) {
        this.decryptCipher = decryptCipher;
    }

    public byte[] getIv() {
        return this.iv;
    }

    @Override
    public void setIv(byte[] iv) throws SecurityUtilsException {
        int IVLENGTH = 16;
        if (iv.length != IVLENGTH) {
            throw new SecurityUtilsException("Initial vector length is not proper, Expected length : " + IVLENGTH + ", Actual length : " + iv.length);
        }
        this.iv = iv;
    }

    public AlgorithmParameterSpec getParamSpec() {
        return this.paramSpec;
    }

    public void setParamSpec(AlgorithmParameterSpec paramSpec) {
        this.paramSpec = paramSpec;
    }

    @Override
    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    @Override
    public void setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
    }

    @Override
    public byte[] getDecryptedData() {
        return this.decryptedData;
    }

    @Override
    public void setDecryptedData(byte[] decryptedData) {
        this.decryptedData = decryptedData;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public void setEncryptionkey(byte[] _descbcencryptionkey) throws SecurityUtilsException {
        int descbcencryptionkeyLENGTH = 16;
        if (_descbcencryptionkey.length != descbcencryptionkeyLENGTH) {
            throw new SecurityUtilsException("Descbcencryptionkey length is not proper, Expected : " + descbcencryptionkeyLENGTH + " Actual : " + _descbcencryptionkey.length);
        }
        this.encryptionkey = _descbcencryptionkey;
    }
}

