/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtility {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtility.class);
    private static SecretKeySpec secretKey;

    public static void setKey(String securityKey) {
        MessageDigest sha = null;
        try {
            byte[] key = securityKey.getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, "AES");
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
    }

    public static String encryptData(String strToEncrypt, String secret) {
        try {
            SecurityUtility.setKey(secret);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            log.error("Error while encrypting: " + e.toString());
            return null;
        }
    }

    public static String decryptData(String strToDecrypt, String secret) {
        try {
            SecurityUtility.setKey(secret);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(2, secretKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
        }
        catch (Exception e) {
            log.error("Error while decrypting: " + e.toString());
            return null;
        }
    }
}

