/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils;

import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.HashType;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.HmacSHA256;

public class HashwithSecret {
    private HashType hashtype;
    private String secret;
    private String data;

    public HashwithSecret setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public HashwithSecret setHashtype(HashType hashtype) {
        this.hashtype = hashtype;
        return this;
    }

    public static HashwithSecret setData(String data) {
        HashwithSecret hws = new HashwithSecret();
        hws.data = data;
        return hws;
    }

    public String create() throws SecurityUtilsException {
        if (this.hashtype.equals((Object)HashType.HMAC_SHA256)) {
            HmacSHA256 hmac = new HmacSHA256();
            return hmac.create(this.data, this.secret);
        }
        throw new SecurityUtilsException("Algorithm not supported " + this.hashtype.toString());
    }

    public boolean verify(String oldhash) throws SecurityUtilsException {
        if (this.hashtype.equals((Object)HashType.HMAC_SHA256)) {
            HmacSHA256 hmac = new HmacSHA256();
            return oldhash.equals(hmac.create(this.data, this.secret));
        }
        throw new SecurityUtilsException("Algorithm not supported " + this.hashtype.toString());
    }
}

