/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils;

import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;

public final class HashUtils {
    private static final int DEFAULT_SALT_LENGTH = 24;
    private static final String DEFAULT_SALT_ALGORITHM = "SHA1PRNG";
    private static final String DEFAULT_SALT_PROVIDER = "SUN";
    public static final char[] pepperarray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    private HashUtils() {
    }

    public static boolean slowEquals(byte[] byteA, byte[] byteB) {
        int diff = byteA.length ^ byteB.length;
        for (int i = 0; i < byteA.length && i < byteB.length; ++i) {
            diff |= byteA[i] ^ byteB[i];
        }
        return diff == 0;
    }

    public static byte[] randomSalt() throws SecurityUtilsException {
        return HashUtils.randomSalt(HashUtils.getsecureRandom(), 24);
    }

    public static byte[] randomSalt(int size) throws SecurityUtilsException {
        return HashUtils.randomSalt(HashUtils.getsecureRandom(), size);
    }

    public static byte[] randomSalt(SecureRandom secureRandom) {
        return HashUtils.randomSalt(secureRandom, 24);
    }

    public static byte[] randomSalt(SecureRandom secureRandom, int size) {
        byte[] salt = new byte[size];
        secureRandom.nextBytes(salt);
        return salt;
    }

    public static SecureRandom getsecureRandom() throws SecurityUtilsException {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(DEFAULT_SALT_ALGORITHM, DEFAULT_SALT_PROVIDER);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new SecurityUtilsException(e);
        }
        return secureRandom;
    }
}

