/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils;

import in.sourceshift.genericmodules.securityutils.BaseEncoder;
import in.sourceshift.genericmodules.securityutils.HashUtils;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.BCrypt;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.HashType;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.PBKDF2;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.SCrypt;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;

public class Hash {
    private static final String SCRYPT = "scrypt";
    private static final String BCRYPT = "bcrypt";
    private static final String PBKDF2_HMACSHA1 = "PBKDF2WithHmacSHA1";
    private static final String PBKDF2_HMACSHA256 = "PBKDF2WithHmacSHA256";
    private static final String PBKDF2_HMACSHA512 = "PBKDF2WithHmacSHA512";
    private static final int HASH_SECTIONS = 8;
    private static final int HASH_ALGORITHM_INDEX = 0;
    private static final int ITERATION_INDEX = 1;
    private static final int HASH_SIZE_INDEX = 2;
    private static final int SALT_SIZE_INDEX = 3;
    private static final int USERSALT_INDEX = 4;
    private static final int SALT_INDEX = 5;
    private static final int HASH_INDEX = 6;
    private static final int PEPPER_INDEX = 7;
    private char[] password;
    private char[] usersalt;
    private boolean isPepper = false;
    private int hashLength = 0;
    private int saltLength = 0;
    private int factor = 0;
    private HashType algorithm = HashType.PBKDF2_SHA1;

    public static Hash password(char[] password) throws SecurityUtilsException {
        if (password == null || password.length < 1) {
            throw new SecurityUtilsException("Password cannot be null or empty.");
        }
        Hash hash = new Hash();
        hash.password = password;
        return hash;
    }

    public Hash addPepper() {
        this.isPepper = true;
        return this;
    }

    public Hash usersalt(char[] usersalt) {
        this.usersalt = usersalt;
        return this;
    }

    public Hash hashLength(int hashLength) {
        this.hashLength = hashLength;
        return this;
    }

    public Hash saltLength(int saltLength) {
        this.saltLength = saltLength;
        return this;
    }

    public Hash algorithm(HashType algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Hash factor(int factor) {
        this.factor = factor;
        return this;
    }

    public String create() throws SecurityUtilsException {
        SecureRandom number;
        try {
            number = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityUtilsException(e);
        }
        char isUsersalted = 'n';
        Object usersaltedpassword = new String(this.password);
        if (this.usersalt != null && this.usersalt.length > 0) {
            isUsersalted = 'y';
            usersaltedpassword = new String(this.usersalt) + (String)usersaltedpassword;
        }
        if (this.isPepper) {
            usersaltedpassword = (String)usersaltedpassword + HashUtils.pepperarray[number.nextInt(HashUtils.pepperarray.length - 1)];
        }
        if (this.algorithm == HashType.PBKDF2_SHA1 || this.algorithm == HashType.PBKDF2_SHA256 || this.algorithm == HashType.PBKDF2_SHA512) {
            PBKDF2 pbkdf2 = new PBKDF2();
            String alg = null;
            String alg2 = null;
            if (this.algorithm == HashType.PBKDF2_SHA1) {
                alg = PBKDF2_HMACSHA1;
                alg2 = "pbkdf2sha1";
            } else if (this.algorithm == HashType.PBKDF2_SHA256) {
                alg = PBKDF2_HMACSHA256;
                alg2 = "pbkdf2sha256";
            } else if (this.algorithm == HashType.PBKDF2_SHA512) {
                alg = PBKDF2_HMACSHA512;
                alg2 = "pbkdf2sha512";
            }
            if (this.hashLength <= 0) {
                this.hashLength = pbkdf2.DEFAULT_HASH_LENGTH;
            }
            if (this.saltLength <= 0) {
                this.saltLength = pbkdf2.DEFAULT_SALT_LENGTH;
            }
            if (this.factor <= 0) {
                this.factor = pbkdf2.DEFAULT_ITERATIONS;
            }
            byte[] salt = HashUtils.randomSalt(this.saltLength);
            byte[] hash = pbkdf2.create(((String)usersaltedpassword).toCharArray(), salt, alg, this.factor, this.hashLength);
            StringBuilder finalHash = new StringBuilder(alg2).append(":").append(this.factor).append(":").append(hash.length).append(":").append(salt.length).append(":").append(isUsersalted).append(":").append(BaseEncoder.encodeBase64toString(salt)).append(":").append(BaseEncoder.encodeBase64toString(hash)).append(":").append(this.isPepper);
            return finalHash.toString();
        }
        if (this.algorithm == HashType.BCRYPT) {
            BCrypt bc = new BCrypt();
            if (this.factor <= 0) {
                this.factor = bc.DEFAULT_LOG2_ROUNDS;
            }
            if (this.saltLength <= 0) {
                Objects.requireNonNull(bc);
                this.saltLength = 16;
            }
            String hash = bc.create((String)usersaltedpassword, null, this.saltLength, this.factor);
            StringBuilder finalHash = new StringBuilder(BCRYPT).append(":").append(this.factor).append(":").append(hash.length()).append(":").append(this.saltLength).append(":").append(isUsersalted).append("::").append(hash).append(":").append(this.isPepper);
            return finalHash.toString();
        }
        if (this.algorithm == HashType.SCRYPT) {
            SCrypt sc = new SCrypt();
            if (this.factor <= 0) {
                this.factor = sc.COST;
            }
            if (this.saltLength <= 0) {
                this.saltLength = sc.DEFAULT_SALT_LENGTH;
            }
            String hash = sc.create((String)usersaltedpassword, this.saltLength, this.factor);
            StringBuilder finalHash = new StringBuilder(SCRYPT).append(":").append(this.factor).append(":").append(hash.length()).append(":").append(this.saltLength).append(":").append(isUsersalted).append("::").append(hash).append(":").append(this.isPepper);
            return finalHash.toString();
        }
        throw new SecurityUtilsException("Unsupported algorithm type. Expected Type.BCRYPT, Type.SCRIPT, or other Type enum.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verify(String correctHash) throws SecurityUtilsException {
        if (correctHash == null || correctHash.isEmpty()) {
            throw new SecurityUtilsException("Correct hash cannot be null or empty.");
        }
        String[] params = correctHash.split(":");
        if (params.length != 8) {
            throw new SecurityUtilsException("Fields are missing from the correct hash. Double-check JHash vesrion and hash format.");
        }
        int iterations = 0;
        try {
            iterations = Integer.parseInt(params[1]);
        }
        catch (NumberFormatException ex) {
            throw new SecurityUtilsException("Could not parse the iteration count as an integer.", ex);
        }
        if (iterations < 1) {
            throw new SecurityUtilsException("Invalid number of iterations. Must be >= 1.");
        }
        Object usersaltedpassword = new String(this.password);
        try {
            if ('y' == params[4].charAt(0)) {
                usersaltedpassword = new String(this.usersalt) + (String)usersaltedpassword;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SecurityUtilsException("Could not parse the usersalt flag.", ex);
        }
        byte[] salt = null;
        try {
            salt = BaseEncoder.decodeBase64(params[5]);
        }
        catch (IllegalArgumentException ex) {
            throw new SecurityUtilsException("Base64 decoding of salt failed.", ex);
        }
        int storedHashSize = 0;
        try {
            storedHashSize = Integer.parseInt(params[2]);
        }
        catch (NumberFormatException ex) {
            throw new SecurityUtilsException("Could not parse the hash size as an integer.", ex);
        }
        int storedSaltSize = 0;
        try {
            storedSaltSize = Integer.parseInt(params[3]);
        }
        catch (NumberFormatException ex) {
            throw new SecurityUtilsException("Could not parse the salt size as an integer.", ex);
        }
        String algorithm = params[0];
        if (algorithm.toLowerCase().startsWith("pbkdf2")) {
            PBKDF2 pbkdf2 = new PBKDF2();
            if ("pbkdf2sha1".equals(algorithm)) {
                algorithm = PBKDF2_HMACSHA1;
            } else if ("pbkdf2sha256".equals(algorithm)) {
                algorithm = PBKDF2_HMACSHA256;
            } else if ("pbkdf2sha512".equals(algorithm)) {
                algorithm = PBKDF2_HMACSHA512;
            }
            byte[] hash = null;
            try {
                hash = BaseEncoder.decodeBase64(params[6]);
            }
            catch (IllegalArgumentException ex) {
                throw new SecurityUtilsException("Base64 decoding of hash failed.", ex);
            }
            if (storedHashSize != hash.length) {
                throw new SecurityUtilsException("Hash length doesn't match stored hash length.");
            }
            if (Boolean.valueOf(params[7]).booleanValue()) {
                for (char element : HashUtils.pepperarray) {
                    byte[] testHash = pbkdf2.create(((String)usersaltedpassword + element).toCharArray(), salt, algorithm, iterations, hash.length);
                    if (!HashUtils.slowEquals(hash, testHash)) continue;
                    return true;
                }
                throw new SecurityUtilsException("Unsupported algorithm type: " + algorithm);
            }
            byte[] testHash = pbkdf2.create(((String)usersaltedpassword).toCharArray(), salt, algorithm, iterations, hash.length);
            return HashUtils.slowEquals(hash, testHash);
        }
        if (algorithm.equals(BCRYPT)) {
            BCrypt bc = new BCrypt();
            byte[] hash = null;
            try {
                hash = params[6].getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                throw new SecurityUtilsException("Parsing of hash failed.", ex);
            }
            if (storedHashSize != hash.length) {
                throw new SecurityUtilsException("Hash length doesn't match stored hash length.");
            }
            if (Boolean.valueOf(params[7]).booleanValue()) {
                for (char element : HashUtils.pepperarray) {
                    byte[] testHash = bc.create((String)usersaltedpassword + element, new String(hash), storedSaltSize, iterations).getBytes(StandardCharsets.UTF_8);
                    if (!HashUtils.slowEquals(hash, testHash)) continue;
                    return true;
                }
                throw new SecurityUtilsException("Unsupported algorithm type: " + algorithm);
            }
            byte[] testHash = bc.create((String)usersaltedpassword, new String(hash), storedSaltSize, iterations).getBytes(StandardCharsets.UTF_8);
            return HashUtils.slowEquals(hash, testHash);
        }
        if (!algorithm.equals(SCRYPT)) throw new SecurityUtilsException("Unsupported algorithm type: " + algorithm);
        SCrypt sc = new SCrypt();
        byte[] hash = null;
        try {
            hash = params[6].getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new SecurityUtilsException("Parsing of hash failed.", ex);
        }
        if (storedHashSize != hash.length) {
            throw new SecurityUtilsException("Hash length doesn't match stored hash length.");
        }
        if (!Boolean.valueOf(params[7]).booleanValue()) return sc.verify((String)usersaltedpassword, new String(hash));
        for (char element : HashUtils.pepperarray) {
            if (!sc.verify((String)usersaltedpassword + element, new String(hash))) continue;
            return true;
        }
        throw new SecurityUtilsException("Unsupported algorithm type: " + algorithm);
    }
}

