/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.securityutils;

import in.sourceshift.genericmodules.securityutils.BaseEncoder;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.AES;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.DES;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.Decrypt;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.EncryptionType;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;

public class Encryption {
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    public EncryptionType encryptionType;
    private byte[] iv;
    private byte[] encryptionkey;
    private byte[] encryptedData;
    private byte[] decryptedData;

    public Encryption(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
    }

    public static Encryption init(EncryptionType encryptionType) {
        return new Encryption(encryptionType);
    }

    public static Encryption init(String encryptiontype) {
        EncryptionType encryption = EncryptionType.valueOf(encryptiontype);
        return new Encryption(encryption);
    }

    public Encryption decrypt() throws SecurityUtilsException {
        Decrypt dec = null;
        if (this.encryptionType.equals((Object)EncryptionType.DES_CBC)) {
            dec = new DES();
            this.decryptCipher = dec.getDecryptCipher();
            this.encryptCipher = dec.getEncryptCipher();
        } else if (this.encryptionType.equals((Object)EncryptionType.AES_CBC)) {
            dec = new AES();
            this.decryptCipher = dec.getDecryptCipher();
            this.encryptCipher = dec.getEncryptCipher();
        }
        dec.setEncryptedData(this.encryptedData);
        dec.setEncryptionkey(this.encryptionkey);
        dec.setIv(this.iv);
        dec.decrypt();
        this.decryptedData = dec.getDecryptedData();
        return this;
    }

    public Encryption encrypt() throws SecurityUtilsException {
        Decrypt enc = null;
        if (this.encryptionType.equals((Object)EncryptionType.DES_CBC)) {
            enc = new DES();
            this.decryptCipher = enc.getDecryptCipher();
            this.encryptCipher = enc.getEncryptCipher();
        } else if (this.encryptionType.equals((Object)EncryptionType.AES_CBC)) {
            enc = new AES();
            this.decryptCipher = enc.getDecryptCipher();
            this.encryptCipher = enc.getEncryptCipher();
        }
        enc.setDecryptedData(this.decryptedData);
        enc.setEncryptionkey(this.encryptionkey);
        enc.setIv(this.iv);
        enc.encrypt();
        this.encryptedData = enc.getEncryptedData();
        return this;
    }

    public Encryption setIv(String iv) {
        this.iv = iv.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public Encryption setIv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    public String getEncryptedData() {
        return BaseEncoder.encodeBase64toString(this.encryptedData);
    }

    public Encryption setEncryptedData(String encryptedData) {
        this.encryptedData = BaseEncoder.decodeBase64(encryptedData);
        return this;
    }

    public Encryption setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
        return this;
    }

    public String getDecryptedData() {
        return new String(this.decryptedData);
    }

    public Encryption setDecryptedData(String decryptedData) {
        this.decryptedData = decryptedData.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public Encryption setDecryptedData(byte[] decryptedData) {
        this.decryptedData = decryptedData;
        return this;
    }

    public Encryption setEncryptionkey(String encryptionkey) {
        this.encryptionkey = encryptionkey.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public Encryption setEncryptionkey(byte[] encryptionkey) {
        this.encryptionkey = encryptionkey;
        return this;
    }

    public Cipher getEncryptCipher() {
        return this.encryptCipher;
    }

    public Cipher getDecryptCipher() {
        return this.decryptCipher;
    }
}

