package in.sourceshift.genericmodules.securityutils.web.jwt;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import in.sourceshift.genericmodules.securityutils.BaseEncoder;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class HeaderProcessor {
    ObjectMapper mappernew = new ObjectMapper();
    ObjectNode keyvalue = mappernew.createObjectNode();
    private final Set<String> predefineheader = new HashSet<>(Arrays.asList("alg", "typ"));

    @Deprecated
    public HeaderProcessor setProperty(String key, String value) {
        if (predefineheader.contains(key)) {
            log.warn("Use inbuild method instade of raw headers");
        }
        keyvalue.put(key, value);
        return this;

    }

    @Deprecated
    public String getProperty(String key) {
        if (predefineheader.contains(key)) {
            log.warn("Use inbuild method instade of raw headers");
        }
        return keyvalue.get(key).asText();

    }

    public HeaderProcessor setTokentype(TokenType tokentype) {
        keyvalue.put("typ", String.valueOf(tokentype));
        return this;
    }

    public TokenType getTokentype() {
        return TokenType.valueOf(keyvalue.get("typ").asText());
    }

    public HeaderProcessor setAlgorithm(JWTHashType algorithm) {
        keyvalue.put("alg", String.valueOf(algorithm));
        return this;
    }

    public JWTHashType getAlgorithm() {
        return JWTHashType.valueOf(keyvalue.get("alg").asText());
    }

    public String getbase64urlencodedJson() throws SecurityUtilsException {

        String json = keyvalue.toString();
        String base64json = BaseEncoder.encodeBase64toString(json);
        String b64url = URLEncoder.encode(base64json, StandardCharsets.UTF_8);
        return b64url;
    }

    public HeaderProcessor decodefrombase64urlencodedJson(String base64urlencodedJson) throws SecurityUtilsException {
        String base64json;
        base64json = URLDecoder.decode(base64urlencodedJson, StandardCharsets.UTF_8);
        String json = BaseEncoder.decodeBase64toString(base64json);
        try {
            keyvalue = (ObjectNode) mappernew.readTree(json);
        } catch (IOException e) {
            throw new SecurityUtilsException("Unable to decode JWTPayload Json", e);
        }
        return this;

    }

    public HeaderProcessor decodefromJson(String headerJson) throws SecurityUtilsException {
        try {
            keyvalue = (ObjectNode) mappernew.readTree(headerJson);
        } catch (IOException e) {
            throw new SecurityUtilsException("Unable to decode JWTPayload Json", e);
        }
        return this;

    }

    @Override
    public String toString() {
        return getHeaderJson();
    }

    public String getHeaderJson() {
        return keyvalue.toString();
    }
}
