package in.sourceshift.genericmodules.securityutils.vaultadapter.utils;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import in.sourceshift.genericmodules.httputils.generic.HTTPExecuter;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import kong.unirest.HttpResponse;

public class VaultHTTPExecutor {

    private final String vaultAPIEndPoint;

    private Map<String, String> headers;

    public VaultHTTPExecutor(String vaultEndPoint) {
        vaultAPIEndPoint = vaultEndPoint + "/v1";
        headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
    }

    public void addCommonHeader(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void addCommonHeader(String k, String v) {
        headers.put(k, v);
    }

    public JsonNode doHTTP(String resourceURI, final String method, Map<String, String> headers, ObjectNode requestBody) throws VaultAdapterException {
        Map<String, String> tempheader;
        String url = vaultAPIEndPoint + resourceURI;
        if (MapUtils.isNotEmpty(headers)) {
            tempheader = new HashMap<>();
            tempheader.putAll(this.headers);
            tempheader.putAll(headers);
        } else {
            tempheader = this.headers;
        }
        ObjectNode resJsonNode;
        try {
            HttpResponse<byte[]> response = null;
            try {
                response = HTTPExecuter.doHTTP(url, method, tempheader, null, requestBody);
            } catch (HTTPUtilsException e) {
                throw new VaultAdapterException("Unable to execute HTTP request", e);
            }
            if ((response.getBody() != null) && (response.getBody().length != 0)) {
                resJsonNode = (ObjectNode) MapUtils.getMapperInstance().readTree(new String(response.getBody()));
            } else {
                resJsonNode = MapUtils.getMapperInstance().createObjectNode();
            }
            resJsonNode.put("VaultHTTPExecutorStatusCode", response.getStatus());
        } catch (Exception e) {
            throw new VaultAdapterException("Unable to make HTTP call", e);
        }
        int status = resJsonNode.at("/VaultHTTPExecutorStatusCode").asInt();
        if ((status >= 400) && (status != 404)) {
            throw new VaultAdapterException("Error from vault service : " + resJsonNode.toString());
        }
        return resJsonNode;
    }

    public JsonNode doGET(String resourceURI) throws VaultAdapterException {
        return this.doGET(resourceURI, null);
    }

    public JsonNode doGET(String resourceURI, Map<String, String> headers) throws VaultAdapterException {
        return doHTTP(resourceURI, "GET", headers, null);
    }

    public JsonNode doPOST(String resourceURI, Map<String, String> headers, ObjectNode requestBody) throws VaultAdapterException {
        return doHTTP(resourceURI, "POST", headers, requestBody);
    }

    public JsonNode doPOST(String resourceURI, ObjectNode requestBody) throws VaultAdapterException {
        return this.doPOST(resourceURI, null, requestBody);
    }

    public JsonNode doPOST(String resourceURI) throws VaultAdapterException {
        return this.doPOST(resourceURI, null, null);
    }

    public JsonNode doLIST(String resourceURI) throws VaultAdapterException {
        return doHTTP(resourceURI, "LIST", null, null);
    }

    public JsonNode doDelete(String resourceURI) throws VaultAdapterException {
        return doHTTP(resourceURI, "DELETE", null, null);
    }

    public void setNamespace(String namespace) {
        if (MapUtils.isNotEmpty(namespace)) {
            headers.put("X-Vault-Namespace", namespace);
        }
    }

    public void setxVaultToken(String xVaultToken) {
        if (MapUtils.isNotEmpty(xVaultToken)) {
            headers.put("X-Vault-Token", xVaultToken);
        }
    }

    public String getxVaultToken() {
        return headers.get("X-Vault-Token");
    }
}
