package in.sourceshift.genericmodules.securityutils.vaultadapter.ops;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class Token {

    private VaultHTTPExecutor httpExecutor;

    public Token(VaultHTTPExecutor httpExecutor) {
        this.httpExecutor = httpExecutor;
    }

    public int doSelfRenewal() throws VaultAdapterException {
        JsonNode res = httpExecutor.doPOST("/auth/token/renew-self");
        return res.get("auth").get("lease_duration").asInt();
    }

    public int doSelfRenewal(int second) throws VaultAdapterException {
        ObjectNode metaNode = MapUtils.getMapperInstance().createObjectNode();
        metaNode.put("increment", second + "s");
        JsonNode res = httpExecutor.doPOST("/auth/token/renew-self", metaNode);
        return res.get("auth").get("lease_duration").asInt();
    }

    public JsonNode doSelfLookup() throws VaultAdapterException {
        return httpExecutor.doGET("/auth/token/lookup-self");
    }

    public int getTtl() throws VaultAdapterException {
        return httpExecutor.doGET("/auth/token/lookup-self").get("data").get("ttl").asInt();
    }

    public String getxVaultToken() {
        return httpExecutor.getxVaultToken();
    }

    public JsonNode doSelfrevoke() throws VaultAdapterException {
        return httpExecutor.doPOST("/auth/token/revoke-self");
    }

}
