package in.sourceshift.genericmodules.securityutils.vaultadapter.ops;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class KVv2 implements KV {
    private final VaultHTTPExecutor httpExecutor;
    private final String secretEngineName;

    public KVv2(VaultHTTPExecutor httpExecutor, String secretEngineName) {
        this.httpExecutor = httpExecutor;
        this.secretEngineName = MapUtils.removeEndStart(secretEngineName, "/");
    }

    @Override
    public JsonNode getKeyValues(String pathOfSecret) throws VaultAdapterException {
        pathOfSecret = MapUtils.removeEndStart(pathOfSecret, "/");
        String keyvalueURI = "/" + secretEngineName + "/data/" + pathOfSecret;
        JsonNode response = httpExecutor.doGET(keyvalueURI);
        try {
            JsonNode responseData = response.at("/data/data");
            if (responseData.isEmpty()) {
                return null;
            }
            return responseData;
        } catch (RuntimeException e) {
            throw new VaultAdapterException(String.format("Unable to Keys Error : [Status=%s, body=%s ]", response.get("VaultHTTPExecutorStatusCode"), response.toPrettyString()));
        }
    }

    @Override
    public JsonNode addorupdateKeyValues(String pathOfSecret, Map<String, String> newKeyValues) throws VaultAdapterException {
        ObjectNode newKeyValuesObjectNode = (ObjectNode) MapUtils.mapAsJsonNode(newKeyValues);
        return this.addorupdateKeyValues(pathOfSecret, newKeyValuesObjectNode);
    }

    @Override
    public JsonNode addorupdateKeyValues(String pathOfSecret, ObjectNode newKeyValues) throws VaultAdapterException {
        JsonNode existingKeyValues = getKeyValues(pathOfSecret);
        ObjectNode updatedKeyValues = MapUtils.mergeJson(existingKeyValues, newKeyValues);
        return postKeyValues(pathOfSecret, updatedKeyValues);
    }

    @Override
    public JsonNode addorupdateKeyValues(String pathOfSecret, String k, String v) throws VaultAdapterException {
        Map<String, String> newKeyValue = new HashMap<>();
        newKeyValue.put(k, v);
        return this.addorupdateKeyValues(pathOfSecret, newKeyValue);
    }

    @Override
    public ArrayNode listKeys(String pathOfSecret) throws VaultAdapterException {
        pathOfSecret = MapUtils.removeEndStart(pathOfSecret, "/");
        String keyvalueURI = "/" + secretEngineName + "/metadata/" + pathOfSecret;
        return (ArrayNode) httpExecutor.doLIST(keyvalueURI).get("data").get("keys");
    }

    @Override
    public JsonNode postKeyValues(String pathOfSecret, ObjectNode keyValues) throws VaultAdapterException {
        pathOfSecret = MapUtils.removeEndStart(pathOfSecret, "/");
        ObjectNode newKeyValuedatanode = MapUtils.getMapperInstance().createObjectNode();
        newKeyValuedatanode.set("data", keyValues);
        String keyvalueURI = "/" + secretEngineName + "/data/" + pathOfSecret;
        return httpExecutor.doPOST(keyvalueURI, newKeyValuedatanode);
    }

    @Override
    public JsonNode removeKeyValues(String pathOfSecret, Set<String> keystoberemoved) throws VaultAdapterException {
        JsonNode existingKeyValues = getKeyValues(pathOfSecret);
        if (existingKeyValues != null) {
            ObjectNode existingObjectNode = (ObjectNode) existingKeyValues;
            existingObjectNode.remove(keystoberemoved);
            return postKeyValues(pathOfSecret, existingObjectNode);
        }
        return null;
    }

    @Override
    public JsonNode removeKeyValues(String pathOfSecret, String keystoberemoved) throws VaultAdapterException {
        Set<String> remove = new HashSet<>();
        remove.add(keystoberemoved);
        return this.removeKeyValues(pathOfSecret, remove);
    }

    @Override
    public void deleteSecretPath(String pathOfSecret) throws VaultAdapterException {
        pathOfSecret = MapUtils.removeEndStart(pathOfSecret, "/");
        httpExecutor.doDelete("/metadata/" + secretEngineName + "/" + pathOfSecret);
    }
}
