package in.sourceshift.genericmodules.securityutils.vaultadapter.ops;

import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;

public interface KV {

    JsonNode getKeyValues(String pathOfSecret) throws VaultAdapterException;

    JsonNode addorupdateKeyValues(String pathOfSecret, String k, String v) throws VaultAdapterException;

    JsonNode addorupdateKeyValues(String pathOfSecret, Map<String, String> newKeyValues) throws VaultAdapterException;

    JsonNode addorupdateKeyValues(String pathOfSecret, ObjectNode newKeyValues) throws VaultAdapterException;

    JsonNode removeKeyValues(String pathOfSecret, String keystoberemoved) throws VaultAdapterException;

    JsonNode removeKeyValues(String pathOfSecret, Set<String> keystoberemoved) throws VaultAdapterException;

    JsonNode postKeyValues(String pathOfSecret, ObjectNode keyValues) throws VaultAdapterException;

    ArrayNode listKeys(String pathOfSecret) throws VaultAdapterException;

    void deleteSecretPath(String pathOfSecret) throws VaultAdapterException;
}
