package in.sourceshift.genericmodules.securityutils.vaultadapter.ops;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class AppRole {

    private VaultHTTPExecutor httpExecutor;

    public AppRole(VaultHTTPExecutor httpExecutor) {
        this.httpExecutor = httpExecutor;
    }

    public String createAppRoleToken(String approle) throws VaultAdapterException {
        String secretidendpoint = "/auth/approle/role/" + approle + "/secret-id";
        JsonNode response = httpExecutor.doPOST(secretidendpoint);
        return response.at("/data/secret_id").asText();
    }

    public String createAppRoleTokenWithMeta(String approle, ObjectNode meta) throws VaultAdapterException {
        String secretidendpoint = "/auth/approle/role/" + approle + "/secret-id";
        JsonNode response = httpExecutor.doPOST(secretidendpoint, meta);
        return response.at("/data/secret_id").asText();
    }

    public String getApproleID(String approle) throws VaultAdapterException {
        String roleidep = "/auth/approle/role/" + approle + "/role-id";
        return httpExecutor.doGET(roleidep).at("/data/role_id").asText();
    }

}
