package in.sourceshift.genericmodules.securityutils.vaultadapter.auth;

import java.util.Map;

import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class VaultAuth {

    private AuthImplementation authimp;

    public VaultAuth(VaultHTTPExecutor httpExecutor, VaultAuthType type, Map<String, String> userPrivate) throws VaultAdapterException {

        String appsecretID = "appsecretID";
        String approleID = "approleID";
        String githubPAT = "githubPAT";
        String password = "password";
        String username = "username";
        String customPath = "customPath";
        switch (type) {
        case LDAP:
            authimp = new LDAPImplementation(httpExecutor, userPrivate.get(username), userPrivate.get(password));
            break;

        case GITHUB:
            authimp = new GitHubImplementation(httpExecutor, userPrivate.get(customPath), userPrivate.get(githubPAT));
            break;

        case USERPASS:
            authimp = new UserpassImplementation(httpExecutor, userPrivate.get(username), userPrivate.get(password));
            break;

        case APPROLE:
            authimp = new AppRoleImplementation(httpExecutor, userPrivate.get(approleID), userPrivate.get(appsecretID));
            break;

        default:
            throw new VaultAdapterException("VaultAuthType not supported");
        }
    }

    public String getXVaultToken() throws VaultAdapterException {
        try {
            authimp.buildAuthendpoint();
            authimp.buildBody();
            return authimp.getXVaultToken();
        } catch (RuntimeException e) {
            throw new VaultAdapterException("Unable to obtain the Vault Authentication token / xVaultToken", e);
        }
    }

    public enum VaultAuthType {
        USERPASS, GITHUB, LDAP, APPROLE
    }

}
