package in.sourceshift.genericmodules.securityutils.vaultadapter.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class LDAPImplementation implements AuthImplementation {

    private final String username;
    private final String password;
    private VaultHTTPExecutor httpExecutor;
    private String vaultAuthenticationEndpoint;
    private ObjectNode body;

    public LDAPImplementation(VaultHTTPExecutor httpExecutor, String username, String password) {
        this.httpExecutor = httpExecutor;
        this.username = username;
        this.password = password;
    }

    @Override
    public String getXVaultToken() throws VaultAdapterException {
        JsonNode response = httpExecutor.doPOST(vaultAuthenticationEndpoint, null, body);
        try {
            return response.get("auth").get("client_token").asText();
        } catch (RuntimeException e) {
            throw new VaultAdapterException(
                    String.format("Unable to get Vault Authentication [Status=%s, body=%s ]", response.get("VaultHTTPExecutorStatusCode"), response.toPrettyString()));
        }
    }

    @Override
    public void buildAuthendpoint() {
        vaultAuthenticationEndpoint = "/auth/ldap/login/" + username;
    }

    @Override
    public void buildBody() {
        body = MapUtils.getMapperInstance().createObjectNode();
        body.put("password", password);
    }
}
