package in.sourceshift.genericmodules.securityutils.vaultadapter;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.securityutils.vaultadapter.auth.VaultAuth;
import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class VaultConfig {
    private final String vaultEndPoint;
    private String xVaultToken = null;
    private VaultAuth.VaultAuthType authenticationType;
    private Map<String, String> userPrivate = new HashMap<>();
    private String namespace;
    private VaultHTTPExecutor httpExecutor;

    public VaultConfig(String vaultEndPoint) {

        this.vaultEndPoint = StringUtils.removeEnd(vaultEndPoint, "/");
    }

    public VaultConfig setCustomPath(String customPath) {
        userPrivate.put("customPath", customPath);
        return this;
    }

    public VaultConfig setGithubPAT(String githubPAT) {
        userPrivate.put("githubPAT", githubPAT);
        return this;
    }

    public VaultConfig setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public VaultConfig setxVaultToken(String xVaultToken) {
        this.xVaultToken = xVaultToken;
        return this;
    }

    public VaultConfig setUsername(String username) {
        userPrivate.put("username", username);
        return this;
    }

    public VaultConfig setPassword(String password) {
        userPrivate.put("password", password);
        return this;
    }

    public VaultConfig setApproleID(String approleID) {
        userPrivate.put("approleID", approleID);
        return this;
    }

    public VaultConfig setAppsecretID(String appsecretID) {
        userPrivate.put("appsecretID", appsecretID);
        return this;
    }

    public static VaultConfig init(String vaultEndPoint) {
        return new VaultConfig(vaultEndPoint);
    }

    private void buildHttpExecutor() {
        if (httpExecutor == null) {
            httpExecutor = new VaultHTTPExecutor(vaultEndPoint);
        }
        if (MapUtils.isNotEmpty(xVaultToken)) {
            httpExecutor.setxVaultToken(xVaultToken);
        }
        if (MapUtils.isNotEmpty(namespace)) {
            httpExecutor.setNamespace(namespace);
        }
    }

    public VaultConfig setAuthenticationType(VaultAuth.VaultAuthType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public VaultAPIAdapter build() throws VaultAdapterException {
        buildHttpExecutor();
        if (xVaultToken == null) {
            xVaultToken = new VaultAuth(httpExecutor, authenticationType, userPrivate).getXVaultToken();
            buildHttpExecutor();
        }
        return new VaultAPIAdapter(httpExecutor);
    }

}
