package in.sourceshift.genericmodules.securityutils.vaultadapter;

import java.io.Closeable;
import java.io.IOException;

import in.sourceshift.genericmodules.securityutils.vaultadapter.exception.VaultAdapterException;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.AppRole;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.KV;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.KVv1;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.KVv2;
import in.sourceshift.genericmodules.securityutils.vaultadapter.ops.Token;
import in.sourceshift.genericmodules.securityutils.vaultadapter.utils.VaultHTTPExecutor;

public class VaultAPIAdapter implements Closeable {

    private VaultHTTPExecutor httpExecutor;

    public VaultAPIAdapter(VaultHTTPExecutor httpExecutor) {
        this.httpExecutor = httpExecutor;
    }

    public KV getKVvinstance(String secretEngineName) throws VaultAdapterException {
        // Default version is set to KV1
        return this.getKVvinstance(secretEngineName, 1);
    }

    public KV getKVvinstance(String secretEngineName, int kvversion) throws VaultAdapterException {
        switch (kvversion) {
        case 1:
            return new KVv1(httpExecutor, secretEngineName);
        case 2:
            return new KVv2(httpExecutor, secretEngineName);
        default:
            throw new VaultAdapterException("Key Value engine version not supported");
        }
    }

    public Token getToken() throws VaultAdapterException {
        return new Token(httpExecutor);
    }

    public AppRole getAppRole() {
        return new AppRole(httpExecutor);
    }

    @Override
    public void close() throws IOException {
        try {
            getToken().doSelfrevoke();
        } catch (VaultAdapterException e) {
            throw new IOException("Unable to revoke xVaultToken", e);
        }

    }
}
