package in.sourceshift.genericmodules.securityutils.hashalgorithms;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import in.sourceshift.genericmodules.securityutils.BaseEncoder;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;

public class HmacSHA256 {
    public final int DEFAULT_SALT_LENGTH = 16;

    public final String HMAC_SHA256 = "HmacSHA256";

    public String create(final String data, String key) throws SecurityUtilsException {
        if (data == null) {
            throw new NullPointerException();
        }
        byte[] hmacKeyBytes = key.getBytes(StandardCharsets.UTF_8);

        Mac hMacSHA256;
        try {
            hMacSHA256 = Mac.getInstance(HMAC_SHA256);
        } catch (NoSuchAlgorithmException e) {
            throw new SecurityUtilsException(e);
        }
        final SecretKeySpec secretKey = new SecretKeySpec(hmacKeyBytes, HMAC_SHA256);
        try {
            hMacSHA256.init(secretKey);
        } catch (InvalidKeyException e) {
            throw new SecurityUtilsException(e);
        }
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] res = hMacSHA256.doFinal(dataBytes);
        return BaseEncoder.encodeBase64toString(res);
    }

}
