package in.sourceshift.genericmodules.securityutils.encryptionalgorithms;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;

public class DES implements Encrypt, Decrypt {

    public DES() throws SecurityUtilsException {
        try {
            encryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            decryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        } catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new SecurityUtilsException(e);
        }

    }

    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private byte[] iv;
    private AlgorithmParameterSpec paramSpec;
    private byte[] encryptedData;
    private byte[] decryptedData;
    private SecretKey secretKey;
    private byte[] encryptionkey;

    public void setKey() {
        secretKey = new SecretKeySpec(encryptionkey, 0, encryptionkey.length, "DES");
    }

    @Override
    public void encrypt() throws SecurityUtilsException {
        setKey();
        paramSpec = new IvParameterSpec(iv);
        try {
            encryptCipher.init(Cipher.ENCRYPT_MODE, secretKey, paramSpec);
            encryptedData = encryptCipher.doFinal(decryptedData);
        } catch (InvalidKeyException | InvalidAlgorithmParameterException | IllegalBlockSizeException | BadPaddingException e) {
            throw new SecurityUtilsException(e);
        }

    }

    @Override
    public void decrypt() throws SecurityUtilsException {
        setKey();
        try {
            decryptCipher.init(Cipher.DECRYPT_MODE, secretKey, paramSpec);
            decryptedData = decryptCipher.doFinal(encryptedData);
        } catch (InvalidKeyException | InvalidAlgorithmParameterException | IllegalBlockSizeException | BadPaddingException e) {
            throw new SecurityUtilsException(e);
        }

    }

    @Override
    public Cipher getEncryptCipher() {
        return encryptCipher;
    }

    @Override
    public Cipher getDecryptCipher() {
        return decryptCipher;
    }

    public byte[] getIv() {
        return iv;
    }

    @Override
    public void setIv(byte[] iv) throws SecurityUtilsException {
        int IVLENGTH = 8;
        if (!(iv.length == IVLENGTH)) {
            throw new SecurityUtilsException("Initial vector length is not proper");
        }
        this.iv = iv;
    }

    public AlgorithmParameterSpec getParamSpec() {
        return paramSpec;
    }

    public void setParamSpec(AlgorithmParameterSpec paramSpec) {
        this.paramSpec = paramSpec;
    }

    public SecretKey getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public byte[] getEncryptedData() {
        return encryptedData;
    }

    @Override
    public void setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
    }

    @Override
    public byte[] getDecryptedData() {
        return decryptedData;
    }

    @Override
    public void setDecryptedData(byte[] decryptedData) {
        this.decryptedData = decryptedData;
    }

    @Override
    public void setEncryptionkey(byte[] _descbcencryptionkey) throws SecurityUtilsException {
        int descbcencryptionkeyLENGTH = 8;
        if (!(_descbcencryptionkey.length == descbcencryptionkeyLENGTH)) {
            throw new SecurityUtilsException("Descbcencryptionkey length is not proper, Expected : " + descbcencryptionkeyLENGTH + " Actual : " + _descbcencryptionkey.length);
        }
        encryptionkey = _descbcencryptionkey;
    }

}
