package in.sourceshift.genericmodules.securityutils;

import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.HashType;
import in.sourceshift.genericmodules.securityutils.hashalgorithms.HmacSHA256;

public class HashwithSecret {
    private HashType hashtype;
    private String secret;

    public HashwithSecret setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public HashwithSecret setHashtype(HashType hashtype) {
        this.hashtype = hashtype;
        return this;
    }

    private String data;

    public static HashwithSecret setData(String data) {

        HashwithSecret hws = new HashwithSecret();
        hws.data = data;
        return hws;
    }

    public String create() throws SecurityUtilsException {
        if (hashtype.equals(HashType.HMAC_SHA256)) {
            HmacSHA256 hmac = new HmacSHA256();
            return hmac.create(data, secret);
        } else {
            throw new SecurityUtilsException("Algorithm not supported " + hashtype.toString());
        }
    }

    public boolean verify(String oldhash) throws SecurityUtilsException {
        if (hashtype.equals(HashType.HMAC_SHA256)) {
            HmacSHA256 hmac = new HmacSHA256();
            return oldhash.equals(hmac.create(data, secret));
        } else {
            throw new SecurityUtilsException("Algorithm not supported " + hashtype.toString());
        }
    }

}
