package in.sourceshift.genericmodules.securityutils;

import java.nio.charset.StandardCharsets;

import javax.crypto.Cipher;

import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.AES;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.DES;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.Decrypt;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.Encrypt;
import in.sourceshift.genericmodules.securityutils.encryptionalgorithms.EncryptionType;
import in.sourceshift.genericmodules.securityutils.exception.SecurityUtilsException;

public class Encryption {

    public Encryption(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;

    }

    private Cipher encryptCipher;
    private Cipher decryptCipher;
    public EncryptionType encryptionType;
    private byte[] iv;
    private byte[] encryptionkey;
    private byte[] encryptedData;
    private byte[] decryptedData;

    public static Encryption init(EncryptionType encryptionType) {
        return new Encryption(encryptionType);
    }

    public static Encryption init(String encryptiontype) {

        EncryptionType encryption = EncryptionType.valueOf(encryptiontype);
        return new Encryption(encryption);
    }

    public Encryption decrypt() throws SecurityUtilsException {
        Decrypt dec = null;
        if (encryptionType.equals(EncryptionType.DES_CBC)) {
            dec = new DES();
            decryptCipher = dec.getDecryptCipher();
            encryptCipher = dec.getEncryptCipher();
        } else if (encryptionType.equals(EncryptionType.AES_CBC)) {
            dec = new AES();
            decryptCipher = dec.getDecryptCipher();
            encryptCipher = dec.getEncryptCipher();
        }
        dec.setEncryptedData(encryptedData);
        dec.setEncryptionkey(encryptionkey);
        dec.setIv(iv);
        dec.decrypt();
        decryptedData = dec.getDecryptedData();
        return this;

    }

    public Encryption encrypt() throws SecurityUtilsException {
        Encrypt enc = null;
        if (encryptionType.equals(EncryptionType.DES_CBC)) {
            enc = new DES();
            decryptCipher = enc.getDecryptCipher();
            encryptCipher = enc.getEncryptCipher();
        } else if (encryptionType.equals(EncryptionType.AES_CBC)) {
            enc = new AES();
            decryptCipher = enc.getDecryptCipher();
            encryptCipher = enc.getEncryptCipher();
        }
        enc.setDecryptedData(decryptedData);
        enc.setEncryptionkey(encryptionkey);
        enc.setIv(iv);
        enc.encrypt();
        encryptedData = enc.getEncryptedData();
        return this;

    }

    public Encryption setIv(String iv) {
        this.iv = iv.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public Encryption setIv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    public String getEncryptedData() {
        return BaseEncoder.encodeBase64toString(encryptedData);
    }

    public Encryption setEncryptedData(String encryptedData) {
        this.encryptedData = BaseEncoder.decodeBase64(encryptedData);
        return this;

    }

    public Encryption setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
        return this;

    }

    public String getDecryptedData() {
        return new String(decryptedData);
    }

    public Encryption setDecryptedData(String decryptedData) {
        this.decryptedData = (decryptedData).getBytes(StandardCharsets.UTF_8);
        return this;

    }

    public Encryption setDecryptedData(byte[] decryptedData) {
        this.decryptedData = decryptedData;
        return this;

    }

    public Encryption setEncryptionkey(String encryptionkey) {
        this.encryptionkey = encryptionkey.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public Encryption setEncryptionkey(byte[] encryptionkey) {
        this.encryptionkey = encryptionkey;
        return this;
    }

    public Cipher getEncryptCipher() {
        return encryptCipher;
    }

    public Cipher getDecryptCipher() {
        return decryptCipher;
    }

}
